/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionRollbackException;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.pool.SqlConnectionPool;
import io.vertx.sqlclient.spi.Driver;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public class PoolImpl
extends SqlClientBase
implements Pool,
Closeable {
    private final VertxInternal vertx;
    private final SqlConnectionPool pool;
    private final CloseFuture closeFuture;
    private final long idleTimeout;
    private final long connectionTimeout;
    private final long maxLifetime;
    private final long cleanerPeriod;
    private final boolean pipelined;
    private volatile Handler<SqlConnectionPool.PooledConnection> connectionInitializer;
    private long timerID;
    private volatile Function<Context, Future<SqlConnection>> connectionProvider;
    public static final String PROPAGATABLE_CONNECTION = "propagatable_connection";

    public PoolImpl(VertxInternal vertx, Driver driver, boolean pipelined, PoolOptions poolOptions, Function<Connection, Future<Void>> afterAcquire, Function<Connection, Future<Void>> beforeRecycle, CloseFuture closeFuture) {
        super(driver);
        VertxMetrics metrics = vertx.metricsSPI();
        PoolMetrics poolMetrics = metrics != null ? metrics.createPoolMetrics("sql", poolOptions.getName(), poolOptions.getMaxSize()) : null;
        this.idleTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getIdleTimeout(), poolOptions.getIdleTimeoutUnit());
        this.connectionTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getConnectionTimeout(), poolOptions.getConnectionTimeoutUnit());
        this.maxLifetime = TimeUnit.MILLISECONDS.convert(poolOptions.getMaxLifetime(), poolOptions.getMaxLifetimeUnit());
        this.cleanerPeriod = poolOptions.getPoolCleanerPeriod();
        this.timerID = -1L;
        this.pipelined = pipelined;
        this.vertx = vertx;
        this.pool = new SqlConnectionPool(ctx -> this.connectionProvider.apply((Context)ctx), () -> this.connectionInitializer, poolMetrics, afterAcquire, beforeRecycle, vertx, this.idleTimeout, this.maxLifetime, poolOptions.getMaxSize(), pipelined, poolOptions.getMaxWaitQueueSize(), poolOptions.getEventLoopSize());
        this.closeFuture = closeFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pool init() {
        this.closeFuture.add((Closeable)this);
        if ((this.idleTimeout > 0L || this.maxLifetime > 0L) && this.cleanerPeriod > 0L) {
            PoolImpl poolImpl = this;
            synchronized (poolImpl) {
                this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.runEviction());
            }
        }
        return this;
    }

    @Override
    public Pool connectionProvider(Function<Context, Future<SqlConnection>> connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runEviction() {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            if (this.timerID == -1L) {
                return;
            }
            this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.runEviction());
        }
        this.pool.evict();
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    @Override
    protected ContextInternal context() {
        return this.vertx.getOrCreateContext();
    }

    @Override
    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.vertx.promise(handler);
    }

    @Override
    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        Future<SqlConnection> fut = this.getConnection();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<SqlConnection> getConnection() {
        ContextInternal current = this.vertx.getOrCreateContext();
        if (this.pipelined) {
            return current.failedFuture("Cannot acquire a connection on a pipelined pool");
        }
        PromiseInternal promise = current.promise();
        this.acquire(current, this.connectionTimeout, (Handler<AsyncResult<SqlConnectionPool.PooledConnection>>)promise);
        return promise.future().map(conn -> {
            SqlConnectionInternal wrapper = this.driver.wrapConnection(current, conn.factory(), (Connection)conn);
            conn.init(wrapper);
            return wrapper;
        });
    }

    public static <T> Future<@Nullable T> startPropagatableConnection(Pool pool, Function<SqlConnection, Future<@Nullable T>> function) {
        ContextInternal context = (ContextInternal)Vertx.currentContext();
        return pool.getConnection().onComplete(handler -> context.putLocal((Object)PROPAGATABLE_CONNECTION, handler.result())).flatMap(conn -> conn.begin().flatMap(tx -> ((Future)function.apply((SqlConnection)conn)).compose(res -> tx.commit().flatMap(v -> context.succeededFuture(res)), err -> {
            if (err instanceof TransactionRollbackException) {
                return context.failedFuture(err);
            }
            return tx.rollback().compose(v -> context.failedFuture(err), failure -> context.failedFuture(err));
        })).onComplete(ar -> conn.close((Handler<AsyncResult<Void>>)((Handler)v -> context.removeLocal((Object)PROPAGATABLE_CONNECTION)))));
    }

    @Override
    public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
        return this.pool.execute(context, cmd);
    }

    private void acquire(ContextInternal context, long timeout, Handler<AsyncResult<SqlConnectionPool.PooledConnection>> completionHandler) {
        this.pool.acquire(context, timeout, completionHandler);
    }

    public void close(Promise<Void> completion) {
        this.doClose().onComplete(completion);
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.closeFuture.close((Promise)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeFuture.close((Promise)this.vertx.promise(handler));
    }

    @Override
    public Pool connectHandler(Handler<SqlConnection> handler) {
        this.connectionInitializer = handler != null ? conn -> {
            ContextInternal current = this.vertx.getContext();
            SqlConnectionInternal wrapper = this.driver.wrapConnection(current, conn.factory(), (Connection)conn);
            conn.init(wrapper);
            current.dispatch((Object)wrapper, handler);
        } : null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> doClose() {
        PoolImpl poolImpl = this;
        synchronized (poolImpl) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        return this.pool.close();
    }

    @Override
    public int size() {
        return this.pool.size();
    }
}

