/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Query;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.TransactionPropagation;
import io.vertx.sqlclient.impl.SqlClientInternal;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Function;

public class PoolBase<P extends Pool>
implements Pool,
SqlClientInternal {
    private final VertxInternal vertx;
    private final CloseFuture closeFuture;
    private final Pool delegate;

    public PoolBase(VertxInternal vertx, CloseFuture closeFuture, Pool delegate) {
        this.vertx = vertx;
        this.closeFuture = closeFuture;
        this.delegate = delegate;
    }

    @Override
    public Driver driver() {
        return ((SqlClientInternal)((Object)this.delegate)).driver();
    }

    @Override
    public void group(Handler<SqlClient> block) {
    }

    @Override
    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        this.delegate.getConnection(handler);
    }

    @Override
    public Future<SqlConnection> getConnection() {
        return this.delegate.getConnection();
    }

    @Override
    public Query<RowSet<Row>> query(String sql) {
        return this.delegate.query(sql);
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql) {
        return this.delegate.preparedQuery(sql);
    }

    @Override
    public <T> Future<@Nullable T> withTransaction(TransactionPropagation txPropagation, Function<SqlConnection, Future<@Nullable T>> function) {
        return this.delegate.withTransaction(txPropagation, function);
    }

    public P connectHandler(Handler<SqlConnection> handler) {
        this.delegate.connectHandler(handler);
        return (P)this;
    }

    public P connectionProvider(Function<Context, Future<SqlConnection>> provider) {
        this.delegate.connectionProvider(provider);
        return (P)this;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public PreparedQuery<RowSet<Row>> preparedQuery(String sql, PrepareOptions options) {
        return this.delegate.preparedQuery(sql, options);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        this.closeFuture.close(handler != null ? closingCtx.promise(handler) : null);
    }

    @Override
    public Future<Void> close() {
        ContextInternal closingCtx = this.vertx.getOrCreateContext();
        PromiseInternal promise = closingCtx.promise();
        this.closeFuture.close((Promise)promise);
        return promise.future();
    }
}

