/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class SimpleQueryTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;

    private static void insertIntoTestTable(TestContext ctx, SqlClient client, int amount, Runnable completionHandler) {
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < 10; ++i) {
            client.query("INSERT INTO mutable (id, val) VALUES (" + i + ", 'Whatever-" + i + "')", ctx.asyncAssertSuccess(r1 -> {
                ctx.assertEquals((Object)1, (Object)r1.rowCount());
                if (count.incrementAndGet() == amount) {
                    completionHandler.run();
                }
            }));
        }
    }

    protected abstract void initConnector();

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    @Before
    public void setUp(TestContext ctx) throws Exception {
        this.vertx = Vertx.vertx();
        this.initConnector();
        this.cleanTestTable(ctx);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.connector.close();
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testQuery(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT id, message from immutable", ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)12, (Object)result.size());
            Row row = result.iterator().next();
            ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
        }))));
    }

    @Test
    public void testQueryError(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("SELECT whatever from DOES_NOT_EXIST", ctx.asyncAssertFailure(err -> {}))));
    }

    @Test
    public void testUpdate(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO mutable (id, val) VALUES (1, 'Whatever')", ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            conn.query("UPDATE mutable SET val = 'newValue' WHERE id = 1", ctx.asyncAssertSuccess(r2 -> {
                ctx.assertEquals((Object)1, (Object)r2.rowCount());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testInsert(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("INSERT INTO mutable (id, val) VALUES (1, 'Whatever');", ctx.asyncAssertSuccess(r1 -> {
            ctx.assertEquals((Object)1, (Object)r1.rowCount());
            async.complete();
        }))));
        async.await();
    }

    @Test
    public void testDelete(TestContext ctx) {
        Async async = ctx.async();
        this.connector.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> SimpleQueryTestBase.insertIntoTestTable(ctx, (SqlClient)conn, 10, () -> conn.query("DELETE FROM mutable where id = 6", ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.rowCount());
            async.complete();
        })))));
    }

    private void cleanTestTable(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE mutable;", ctx.asyncAssertSuccess(result -> conn.close()))));
    }
}

