/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class ConnectionTestBase {
    protected Vertx vertx;
    protected Connector<SqlConnection> connector;
    protected SqlConnectOptions options;

    protected void connect(Handler<AsyncResult<SqlConnection>> handler) {
        this.connector.connect(handler);
    }

    @Before
    public void setUp() throws Exception {
        this.vertx = Vertx.vertx();
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testConnect(TestContext ctx) {
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {}));
    }

    @Test
    public void testConnectInvalidDatabase(TestContext ctx) {
        this.options.setDatabase("invalidDatabase");
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertFailure(err -> {}));
    }

    @Test
    public void testConnectInvalidPassword(TestContext ctx) {
        this.options.setPassword("invalidPassword");
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertFailure(err -> {}));
    }

    @Test
    public void testConnectInvalidUsername(TestContext ctx) {
        this.options.setUser("invalidUsername");
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertFailure(err -> {}));
    }

    @Test
    public void testClose(TestContext ctx) {
        Async async = ctx.async();
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            conn.closeHandler(v -> async.complete());
            conn.close();
        }));
        async.await();
    }

    @Test
    public void testCloseWithErrorInProgress(TestContext ctx) {
        Async async = ctx.async(2);
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT whatever from DOES_NOT_EXIST", ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)2, (Object)async.count());
                async.countDown();
            }));
            conn.closeHandler(v -> {
                ctx.assertEquals((Object)1, (Object)async.count());
                async.countDown();
            });
            conn.close();
        }));
        async.await();
    }

    @Test
    public void testCloseWithQueryInProgress(TestContext ctx) {
        Async async = ctx.async(2);
        this.connect((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> {
            conn.query("SELECT id, message from immutable", ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)2, (Object)async.count());
                ctx.assertEquals((Object)12, (Object)result.size());
                async.countDown();
            }));
            conn.closeHandler(v -> {
                ctx.assertEquals((Object)1, (Object)async.count());
                async.countDown();
            });
            conn.close();
        }));
        async.await();
    }
}

