/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy.sockjs.generator;

import io.vertx.codegen.Case;
import io.vertx.codegen.Helper;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.ParameterizedTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.writer.CodeWriter;
import io.vertx.serviceproxy.generator.model.ProxyModel;
import io.vertx.serviceproxy.sockjs.generator.SockjsServiceProxyJSGenerator;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SockjsServiceProxyTSGenerator
extends SockjsServiceProxyJSGenerator {
    @Override
    public String filename(ProxyModel model) {
        ClassTypeInfo type = model.getType();
        return "resources/" + type.getModuleName() + "-js/" + Helper.convertCamelCaseToUnderscores((String)type.getRaw().getSimpleName()) + "-proxy.d.ts";
    }

    @Override
    public String render(ProxyModel model, int index, int size, Map<String, Object> session) {
        StringWriter sw = new StringWriter();
        CodeWriter writer = new CodeWriter((Writer)sw);
        String simpleName = model.getIfaceSimpleName();
        this.genLicenses((PrintWriter)writer);
        writer.println();
        for (ApiTypeInfo referencedType : model.getReferencedTypes()) {
            if (!referencedType.isProxyGen()) continue;
            String refedType = referencedType.getSimpleName();
            writer.format("import { %s } from './%s-proxy';", new Object[]{refedType, this.getModuleName((ClassTypeInfo)referencedType)}).println();
        }
        writer.println();
        this.genDoc(model, writer);
        writer.format("export default class %s {", new Object[]{simpleName}).println();
        writer.println();
        writer.indent();
        writer.println("constructor (eb: any, address: string);");
        for (String methodName : model.getMethodMap().keySet()) {
            this.genMethod(model, methodName, false, this::methodFilter, writer);
        }
        writer.unindent();
        writer.print("}");
        return sw.toString();
    }

    private void genMethod(ProxyModel model, String methodName, boolean genStatic, Predicate<MethodInfo> methodFilter, CodeWriter writer) {
        MethodInfo method;
        String simpleName = model.getIfaceSimpleName();
        Map methodsByName = model.getMethodMap();
        ArrayList<MethodInfo> methodList = (ArrayList<MethodInfo>)methodsByName.get(methodName);
        if (methodFilter != null) {
            ArrayList<MethodInfo> methodTmpl = methodList;
            methodList = new ArrayList<MethodInfo>();
            for (MethodInfo method2 : methodTmpl) {
                if (!methodFilter.test(method2)) continue;
                methodList.add(method2);
            }
        }
        if (methodList.size() > 0 && genStatic == (method = (MethodInfo)methodList.get(methodList.size() - 1)).isStaticMethod()) {
            writer.println();
            if (genStatic) {
                writer.print("static ");
            }
            writer.format("%s(%s) : ", new Object[]{methodName, method.getParams().stream().map(p -> p.getName() + ": " + this.getTSDocType(p.getType())).collect(Collectors.joining(", "))});
            if (method.isFluent()) {
                writer.print(simpleName);
            } else {
                writer.print("void");
            }
            writer.println(";");
        }
    }

    private String getTSDocType(TypeInfo type) {
        switch (type.getKind()) {
            case STRING: {
                return "string" + (type.isNullable() ? " | null" : "");
            }
            case PRIMITIVE: 
            case BOXED_PRIMITIVE: {
                switch (type.getSimpleName()) {
                    case "boolean": 
                    case "Boolean": {
                        return "boolean" + (type.isNullable() ? " | null" : "");
                    }
                    case "char": 
                    case "Character": {
                        return "string" + (type.isNullable() ? " | null" : "");
                    }
                }
                return "number" + (type.isNullable() ? " | null" : "");
            }
            case JSON_OBJECT: {
                return "Object" + (type.isNullable() ? " | null" : "");
            }
            case JSON_ARRAY: {
                return "Array" + (type.isNullable() ? " | null" : "");
            }
            case DATA_OBJECT: {
                return "any" + (type.isNullable() ? " | null" : "");
            }
            case ENUM: {
                return "string" + (type.isNullable() ? " | null" : "");
            }
            case API: {
                return type.getRaw().getSimpleName() + (type.isNullable() ? " | null" : "");
            }
            case MAP: {
                return "Object<string, " + this.getTSDocType(((ParameterizedTypeInfo)type).getArg(1)) + ">" + (type.isNullable() ? " | null" : "");
            }
            case SET: 
            case LIST: {
                return "Array<" + this.getTSDocType(((ParameterizedTypeInfo)type).getArg(0)) + ">" + (type.isNullable() ? " | null" : "");
            }
            case OBJECT: {
                return "any";
            }
            case HANDLER: {
                ParameterizedTypeInfo handlerType = (ParameterizedTypeInfo)type;
                ParameterizedTypeInfo asyncResultType = (ParameterizedTypeInfo)handlerType.getArg(0);
                TypeInfo resultType = asyncResultType.getArg(0);
                switch (resultType.getKind()) {
                    case API: 
                    case STRING: 
                    case PRIMITIVE: 
                    case JSON_OBJECT: 
                    case JSON_ARRAY: 
                    case DATA_OBJECT: 
                    case ENUM: 
                    case MAP: 
                    case SET: 
                    case LIST: 
                    case OBJECT: {
                        return "(err: any, result: " + this.getTSDocType(resultType) + ") => any";
                    }
                }
                return "(err: any, result: any) => any";
            }
        }
        return "todo";
    }

    private String getModuleName(ClassTypeInfo type) {
        return type.getModuleName() + "-js/" + Case.CAMEL.to(Case.SNAKE, type.getSimpleName());
    }
}

