/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.datagram;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements RxDelegate,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private static final TypeArg<DatagramSocket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramSocket.newInstance((io.vertx.core.datagram.DatagramSocket)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public DatagramSocket(Object delegate) {
        this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Completable send(Buffer packet, int port, String host) {
        Completable ret = this.rxSend(packet, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(Buffer packet, int port, String host) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(packet, port, host));
    }

    public WriteStream<Buffer> sender(int port, String host) {
        WriteStream<Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TypeArg.unknown());
        return ret;
    }

    public Completable send(String str, int port, String host) {
        Completable ret = this.rxSend(str, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String str, int port, String host) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(str, port, host));
    }

    public Completable send(String str, String enc, int port, String host) {
        Completable ret = this.rxSend(str, enc, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String str, String enc, int port, String host) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.send(str, enc, port, host));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.localAddress();
        return ret;
    }

    public Completable listenMulticastGroup(String multicastAddress) {
        Completable ret = this.rxListenMulticastGroup(multicastAddress);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.listenMulticastGroup(multicastAddress));
    }

    public Completable listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Completable ret = this.rxListenMulticastGroup(multicastAddress, networkInterface, source);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source));
    }

    public Completable unlistenMulticastGroup(String multicastAddress) {
        Completable ret = this.rxUnlistenMulticastGroup(multicastAddress);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.unlistenMulticastGroup(multicastAddress));
    }

    public Completable unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Completable ret = this.rxUnlistenMulticastGroup(multicastAddress, networkInterface, source);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source));
    }

    public Completable blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        Completable ret = this.rxBlockMulticastGroup(multicastAddress, sourceToBlock);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock));
    }

    public Completable blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        Completable ret = this.rxBlockMulticastGroup(multicastAddress, networkInterface, sourceToBlock);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock));
    }

    public Single<DatagramSocket> listen(int port, String host) {
        Single ret = this.rxListen(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(() -> this.delegate.listen(port, host), __value -> DatagramSocket.newInstance(__value));
    }

    public DatagramSocket handler(Handler<DatagramPacket> handler) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.handler(handler));
        return ret;
    }

    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        DatagramSocket ret = DatagramSocket.newInstance(this.delegate.exceptionHandler(handler));
        return ret;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

