/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.web.sstore;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.web.Session;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.ext.web.sstore.SessionStore.class)
public class SessionStore
implements RxDelegate {
    public static final TypeArg<SessionStore> __TYPE_ARG = new TypeArg(obj -> new SessionStore((io.vertx.ext.web.sstore.SessionStore)obj), SessionStore::getDelegate);
    private final io.vertx.ext.web.sstore.SessionStore delegate;
    private static final TypeArg<Session> TYPE_ARG_0 = new TypeArg(o1 -> Session.newInstance((io.vertx.ext.web.Session)o1), o1 -> o1.getDelegate());
    public static final int DEFAULT_SESSIONID_LENGTH = 16;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionStore that = (SessionStore)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public SessionStore(Object delegate) {
        this.delegate = (io.vertx.ext.web.sstore.SessionStore)delegate;
    }

    public io.vertx.ext.web.sstore.SessionStore getDelegate() {
        return this.delegate;
    }

    public static SessionStore create(io.vertx.rxjava3.core.Vertx vertx) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static SessionStore create(io.vertx.rxjava3.core.Vertx vertx, JsonObject options) {
        SessionStore ret = SessionStore.newInstance(io.vertx.ext.web.sstore.SessionStore.create((Vertx)vertx.getDelegate(), (JsonObject)options));
        return ret;
    }

    public SessionStore init(io.vertx.rxjava3.core.Vertx vertx, JsonObject options) {
        this.delegate.init(vertx.getDelegate(), options);
        return this;
    }

    public long retryTimeout() {
        long ret = this.delegate.retryTimeout();
        return ret;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public Session createSession(long timeout, int length) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout, length));
        return ret;
    }

    public Maybe<Session> get(String cookieValue) {
        Maybe ret = this.rxGet(cookieValue);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<Session> rxGet(String cookieValue) {
        return AsyncResultMaybe.toMaybe(() -> this.delegate.get(cookieValue), __value -> Session.newInstance(__value));
    }

    public Completable delete(String id) {
        Completable ret = this.rxDelete(id);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.delete(id));
    }

    public Completable put(Session session) {
        Completable ret = this.rxPut(session);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxPut(Session session) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.put(session.getDelegate()));
    }

    public Completable clear() {
        Completable ret = this.rxClear();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClear() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.clear());
    }

    public Single<Integer> size() {
        Single ret = this.rxSize();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Integer> rxSize() {
        return AsyncResultSingle.toSingle(() -> this.delegate.size(), __value -> __value);
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

