/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.mongo;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.GridFsDownloadOptions;
import io.vertx.ext.mongo.GridFsUploadOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.ReadStreamSubscriber;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoGridFsClient.class)
public class MongoGridFsClient
implements RxDelegate {
    public static final TypeArg<MongoGridFsClient> __TYPE_ARG = new TypeArg(obj -> new MongoGridFsClient((io.vertx.ext.mongo.MongoGridFsClient)obj), MongoGridFsClient::getDelegate);
    private final io.vertx.ext.mongo.MongoGridFsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoGridFsClient that = (MongoGridFsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoGridFsClient(io.vertx.ext.mongo.MongoGridFsClient delegate) {
        this.delegate = delegate;
    }

    public MongoGridFsClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoGridFsClient)delegate;
    }

    public io.vertx.ext.mongo.MongoGridFsClient getDelegate() {
        return this.delegate;
    }

    public Completable delete(String id) {
        Completable ret = this.rxDelete(id);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDelete(String id) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.delete(id));
    }

    public ReadStream<Buffer> readByFileName(String fileName) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileName(fileName), TypeArg.unknown());
        return ret;
    }

    public ReadStream<Buffer> readByFileNameWithOptions(String fileName, GridFsDownloadOptions options) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readByFileNameWithOptions(fileName, options), TypeArg.unknown());
        return ret;
    }

    public ReadStream<Buffer> readById(String id) {
        ReadStream<Buffer> ret = ReadStream.newInstance(this.delegate.readById(id), TypeArg.unknown());
        return ret;
    }

    public Single<Long> downloadByFileName(WriteStream<Buffer> stream, String fileName) {
        Single ret = this.rxDownloadByFileName(stream, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadByFileName(WriteStream<Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadByFileName(stream.getDelegate(), fileName), __value -> __value);
    }

    public Single<Long> downloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        Single ret = this.rxDownloadByFileNameWithOptions(stream, fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadByFileNameWithOptions(WriteStream<Buffer> stream, String fileName, GridFsDownloadOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadByFileNameWithOptions(stream.getDelegate(), fileName, options), __value -> __value);
    }

    public Single<Long> downloadById(WriteStream<Buffer> stream, String id) {
        Single ret = this.rxDownloadById(stream, id);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadById(WriteStream<Buffer> stream, String id) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadById(stream.getDelegate(), id), __value -> __value);
    }

    public Single<Long> downloadFile(String fileName) {
        Single ret = this.rxDownloadFile(fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFile(String fileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadFile(fileName), __value -> __value);
    }

    public Single<Long> downloadFileAs(String fileName, String newFileName) {
        Single ret = this.rxDownloadFileAs(fileName, newFileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFileAs(String fileName, String newFileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadFileAs(fileName, newFileName), __value -> __value);
    }

    public Single<Long> downloadFileByID(String id, String fileName) {
        Single ret = this.rxDownloadFileByID(id, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxDownloadFileByID(String id, String fileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.downloadFileByID(id, fileName), __value -> __value);
    }

    public Completable drop() {
        Completable ret = this.rxDrop();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDrop() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.drop());
    }

    public Single<List<String>> findAllIds() {
        Single ret = this.rxFindAllIds();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxFindAllIds() {
        return AsyncResultSingle.toSingle(() -> this.delegate.findAllIds(), __value -> __value);
    }

    public Single<List<String>> findIds(JsonObject query) {
        Single ret = this.rxFindIds(query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxFindIds(JsonObject query) {
        return AsyncResultSingle.toSingle(() -> this.delegate.findIds(query), __value -> __value);
    }

    public Single<String> uploadByFileName(Flowable<Buffer> stream, String fileName) {
        Single ret = this.rxUploadByFileName(stream, fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadByFileName(Flowable<Buffer> stream, String fileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.uploadByFileName(ReadStreamSubscriber.asReadStream((Flowable)stream, obj -> obj).resume(), fileName), __value -> __value);
    }

    public Single<String> uploadByFileNameWithOptions(Flowable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        Single ret = this.rxUploadByFileNameWithOptions(stream, fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadByFileNameWithOptions(Flowable<Buffer> stream, String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.uploadByFileNameWithOptions(ReadStreamSubscriber.asReadStream((Flowable)stream, obj -> obj).resume(), fileName, options), __value -> __value);
    }

    public Single<String> uploadFile(String fileName) {
        Single ret = this.rxUploadFile(fileName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadFile(String fileName) {
        return AsyncResultSingle.toSingle(() -> this.delegate.uploadFile(fileName), __value -> __value);
    }

    public Single<String> uploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        Single ret = this.rxUploadFileWithOptions(fileName, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxUploadFileWithOptions(String fileName, GridFsUploadOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.uploadFileWithOptions(fileName, options), __value -> __value);
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoGridFsClient newInstance(io.vertx.ext.mongo.MongoGridFsClient arg) {
        return arg != null ? new MongoGridFsClient(arg) : null;
    }
}

