/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements RxDelegate,
ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private WriteStreamObserver<Buffer> observer;
    private WriteStreamSubscriber<Buffer> subscriber;
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<Buffer> toObserver() {
        if (this.observer == null) {
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate());
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.pipeTo(dst.getDelegate()));
    }

    @Override
    public Completable write(Buffer data) {
        Completable ret = this.rxWrite(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write((Object)data));
    }

    @Override
    public Completable end(Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end((Object)data));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    public Completable write(String str) {
        Completable ret = this.rxWrite(str);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(String str) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write(str));
    }

    public Completable write(String str, String enc) {
        Completable ret = this.rxWrite(str, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(String str, String enc) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.write(str, enc));
    }

    public Completable sendFile(String filename) {
        Completable ret = this.rxSendFile(filename);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename));
    }

    public Completable sendFile(String filename, long offset) {
        Completable ret = this.rxSendFile(filename, offset);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename, offset));
    }

    public Completable sendFile(String filename, long offset, long length) {
        Completable ret = this.rxSendFile(filename, offset, length);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.sendFile(filename, offset, length));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.remoteAddress();
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = this.delegate.remoteAddress(real);
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.localAddress();
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = this.delegate.localAddress(real);
        return ret;
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.end());
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.close());
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public NetSocket shutdownHandler(Handler<Void> handler) {
        this.delegate.shutdownHandler(handler);
        return this;
    }

    public Completable upgradeToSsl() {
        Completable ret = this.rxUpgradeToSsl();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl() {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl());
    }

    public Completable upgradeToSsl(Buffer msg) {
        Completable ret = this.rxUpgradeToSsl(msg);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(Buffer msg) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(msg));
    }

    public Completable upgradeToSsl(String serverName) {
        Completable ret = this.rxUpgradeToSsl(serverName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(String serverName) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(serverName));
    }

    public Completable upgradeToSsl(String serverName, Buffer msg) {
        Completable ret = this.rxUpgradeToSsl(serverName, msg);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(String serverName, Buffer msg) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(serverName, msg));
    }

    public Completable upgradeToSsl(SSLOptions sslOptions, String serverName) {
        Completable ret = this.rxUpgradeToSsl(sslOptions, serverName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, String serverName) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(sslOptions, serverName));
    }

    public Completable upgradeToSsl(SSLOptions sslOptions, Buffer msg) {
        Completable ret = this.rxUpgradeToSsl(sslOptions, msg);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, Buffer msg) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(sslOptions, msg));
    }

    public Completable upgradeToSsl(SSLOptions sslOptions, String serverName, Buffer upgrade) {
        Completable ret = this.rxUpgradeToSsl(sslOptions, serverName, upgrade);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions, String serverName, Buffer upgrade) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(sslOptions, serverName, upgrade));
    }

    public Completable upgradeToSsl(SSLOptions sslOptions) {
        Completable ret = this.rxUpgradeToSsl(sslOptions);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(SSLOptions sslOptions) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.upgradeToSsl(sslOptions));
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

