/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.file;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.file.AsyncFile;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem
implements RxDelegate {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;
    private static final TypeArg<AsyncFile> TYPE_ARG_0 = new TypeArg(o1 -> AsyncFile.newInstance((io.vertx.core.file.AsyncFile)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public Completable copy(String from, String to) {
        Completable ret = this.rxCopy(from, to);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCopy(String from, String to) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.copy(from, to));
    }

    public Completable copy(String from, String to, CopyOptions options) {
        Completable ret = this.rxCopy(from, to, options);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCopy(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.copy(from, to, options));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public Completable copyRecursive(String from, String to, boolean recursive) {
        Completable ret = this.rxCopyRecursive(from, to, recursive);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCopyRecursive(String from, String to, boolean recursive) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.copyRecursive(from, to, recursive));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    public Completable move(String from, String to) {
        Completable ret = this.rxMove(from, to);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMove(String from, String to) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.move(from, to));
    }

    public Completable move(String from, String to, CopyOptions options) {
        Completable ret = this.rxMove(from, to, options);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMove(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.move(from, to, options));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public Completable truncate(String path, long len) {
        Completable ret = this.rxTruncate(path, len);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxTruncate(String path, long len) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.truncate(path, len));
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    public Completable chmod(String path, String perms) {
        Completable ret = this.rxChmod(path, perms);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxChmod(String path, String perms) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.chmod(path, perms));
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    public Completable chmodRecursive(String path, String perms, String dirPerms) {
        Completable ret = this.rxChmodRecursive(path, perms, dirPerms);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxChmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.chmodRecursive(path, perms, dirPerms));
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    public Completable chown(String path, String user, String group) {
        Completable ret = this.rxChown(path, user, group);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxChown(String path, String user, String group) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.chown(path, user, group));
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    public Single<FileProps> props(String path) {
        Single ret = this.rxProps(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<FileProps> rxProps(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.props(path), __value -> __value);
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = this.delegate.propsBlocking(path);
        return ret;
    }

    public Single<FileProps> lprops(String path) {
        Single ret = this.rxLprops(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<FileProps> rxLprops(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.lprops(path), __value -> __value);
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = this.delegate.lpropsBlocking(path);
        return ret;
    }

    public Completable link(String link, String existing) {
        Completable ret = this.rxLink(link, existing);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxLink(String link, String existing) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.link(link, existing));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public Completable symlink(String link, String existing) {
        Completable ret = this.rxSymlink(link, existing);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSymlink(String link, String existing) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.symlink(link, existing));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public Completable unlink(String link) {
        Completable ret = this.rxUnlink(link);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnlink(String link) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.unlink(link));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public Single<String> readSymlink(String link) {
        Single ret = this.rxReadSymlink(link);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxReadSymlink(String link) {
        return AsyncResultSingle.toSingle(() -> this.delegate.readSymlink(link), __value -> __value);
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public Completable delete(String path) {
        Completable ret = this.rxDelete(path);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDelete(String path) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.delete(path));
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    public Completable deleteRecursive(String path, boolean recursive) {
        Completable ret = this.rxDeleteRecursive(path, recursive);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDeleteRecursive(String path, boolean recursive) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.deleteRecursive(path, recursive));
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    public Completable mkdir(String path) {
        Completable ret = this.rxMkdir(path);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMkdir(String path) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.mkdir(path));
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    public Completable mkdir(String path, String perms) {
        Completable ret = this.rxMkdir(path, perms);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMkdir(String path, String perms) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.mkdir(path, perms));
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    public Completable mkdirs(String path) {
        Completable ret = this.rxMkdirs(path);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMkdirs(String path) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.mkdirs(path));
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    public Completable mkdirs(String path, String perms) {
        Completable ret = this.rxMkdirs(path, perms);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxMkdirs(String path, String perms) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.mkdirs(path, perms));
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    public Single<List<String>> readDir(String path) {
        Single ret = this.rxReadDir(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxReadDir(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.readDir(path), __value -> __value);
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    public Single<List<String>> readDir(String path, String filter) {
        Single ret = this.rxReadDir(path, filter);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxReadDir(String path, String filter) {
        return AsyncResultSingle.toSingle(() -> this.delegate.readDir(path, filter), __value -> __value);
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    public Single<Buffer> readFile(String path) {
        Single ret = this.rxReadFile(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Buffer> rxReadFile(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.readFile(path), __value -> __value);
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = this.delegate.readFileBlocking(path);
        return ret;
    }

    public Completable writeFile(String path, Buffer data) {
        Completable ret = this.rxWriteFile(path, data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWriteFile(String path, Buffer data) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.writeFile(path, data));
    }

    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, data);
        return this;
    }

    public Single<AsyncFile> open(String path, OpenOptions options) {
        Single ret = this.rxOpen(path, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<AsyncFile> rxOpen(String path, OpenOptions options) {
        return AsyncResultSingle.toSingle(() -> this.delegate.open(path, options), __value -> AsyncFile.newInstance(__value));
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    public Completable createFile(String path) {
        Completable ret = this.rxCreateFile(path);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateFile(String path) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.createFile(path));
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    public Completable createFile(String path, String perms) {
        Completable ret = this.rxCreateFile(path, perms);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateFile(String path, String perms) {
        return AsyncResultCompletable.toCompletable(() -> this.delegate.createFile(path, perms));
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    public Single<Boolean> exists(String path) {
        Single ret = this.rxExists(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxExists(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.exists(path), __value -> __value);
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    public Single<FileSystemProps> fsProps(String path) {
        Single ret = this.rxFsProps(path);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<FileSystemProps> rxFsProps(String path) {
        return AsyncResultSingle.toSingle(() -> this.delegate.fsProps(path), __value -> __value);
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = this.delegate.fsPropsBlocking(path);
        return ret;
    }

    public Single<String> createTempDirectory(String prefix) {
        Single ret = this.rxCreateTempDirectory(prefix);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempDirectory(prefix), __value -> __value);
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    public Single<String> createTempDirectory(String prefix, String perms) {
        Single ret = this.rxCreateTempDirectory(prefix, perms);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix, String perms) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempDirectory(prefix, perms), __value -> __value);
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    public Single<String> createTempDirectory(String dir, String prefix, String perms) {
        Single ret = this.rxCreateTempDirectory(dir, prefix, perms);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempDirectory(dir, prefix, perms), __value -> __value);
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    public Single<String> createTempFile(String prefix, String suffix) {
        Single ret = this.rxCreateTempFile(prefix, suffix);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempFile(prefix, suffix), __value -> __value);
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    public Single<String> createTempFile(String prefix, String suffix, String perms) {
        Single ret = this.rxCreateTempFile(prefix, suffix, perms);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempFile(prefix, suffix, perms), __value -> __value);
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    public Single<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        Single ret = this.rxCreateTempFile(dir, prefix, suffix, perms);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<String> rxCreateTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle(() -> this.delegate.createTempFile(dir, prefix, suffix, perms), __value -> __value);
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

