/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.net.NetSocket;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetServer.class)
public class NetServer
implements Measured {
    public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg(obj -> new NetServer((io.vertx.core.net.NetServer)obj), NetServer::getDelegate);
    private final io.vertx.core.net.NetServer delegate;
    private static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetServer that = (NetServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetServer(io.vertx.core.net.NetServer delegate) {
        this.delegate = delegate;
    }

    public NetServer(Object delegate) {
        this.delegate = (io.vertx.core.net.NetServer)delegate;
    }

    public io.vertx.core.net.NetServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Deprecated
    public ReadStream<NetSocket> connectStream() {
        ReadStream<NetSocket> ret = ReadStream.newInstance(this.delegate.connectStream(), TYPE_ARG_0);
        return ret;
    }

    public NetServer connectHandler(Handler<NetSocket> handler) {
        NetServer ret = NetServer.newInstance(this.delegate.connectHandler((Handler)new DelegatingHandler(handler, event -> NetSocket.newInstance(event))));
        return ret;
    }

    public Single<NetServer> listen() {
        Single ret = this.rxListen();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetServer> rxListen() {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen((Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public Single<NetServer> listen(int port, String host) {
        Single ret = this.rxListen(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen(port, host, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public Single<NetServer> listen(int port) {
        Single ret = this.rxListen(port);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetServer> rxListen(int port) {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen(port, (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public Single<NetServer> listen(SocketAddress localAddress) {
        Single ret = this.rxListen(localAddress);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<NetServer> rxListen(SocketAddress localAddress) {
        return AsyncResultSingle.toSingle(listenHandler -> this.delegate.listen(localAddress.getDelegate(), (Handler)new DelegatingHandler(listenHandler, ar -> ar.map(event -> NetServer.newInstance(event)))));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(completionHandler -> this.delegate.close(completionHandler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, handler));
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, force, handler));
    }

    public void updateTrafficShapingOptions(TrafficShapingOptions options) {
        this.delegate.updateTrafficShapingOptions(options);
    }

    public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
        return arg != null ? new NetServer(arg) : null;
    }
}

