/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.net.NetSocket.class)
public class NetSocket
implements RxDelegate,
ReadStream<io.vertx.rxjava3.core.buffer.Buffer>,
WriteStream<io.vertx.rxjava3.core.buffer.Buffer> {
    public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg(obj -> new NetSocket((io.vertx.core.net.NetSocket)obj), NetSocket::getDelegate);
    private final io.vertx.core.net.NetSocket delegate;
    private Observable<io.vertx.rxjava3.core.buffer.Buffer> observable;
    private Flowable<io.vertx.rxjava3.core.buffer.Buffer> flowable;
    private WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> observer;
    private WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> subscriber;
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;
    private SocketAddress cached_1;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetSocket that = (NetSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetSocket(io.vertx.core.net.NetSocket delegate) {
        this.delegate = delegate;
    }

    public NetSocket(Object delegate) {
        this.delegate = (io.vertx.core.net.NetSocket)delegate;
    }

    public io.vertx.core.net.NetSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<io.vertx.rxjava3.core.buffer.Buffer> toObservable() {
        if (this.observable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<io.vertx.rxjava3.core.buffer.Buffer> toFlowable() {
        if (this.flowable == null) {
            Function<Buffer, io.vertx.rxjava3.core.buffer.Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::newInstance;
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public synchronized WriteStreamObserver<io.vertx.rxjava3.core.buffer.Buffer> toObserver() {
        if (this.observer == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.observer = RxHelper.toObserver((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.observer;
    }

    @Override
    public synchronized WriteStreamSubscriber<io.vertx.rxjava3.core.buffer.Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<io.vertx.rxjava3.core.buffer.Buffer, Buffer> conv = io.vertx.rxjava3.core.buffer.Buffer::getDelegate;
            this.subscriber = RxHelper.toSubscriber((io.vertx.core.streams.WriteStream)this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Completable end(io.vertx.rxjava3.core.buffer.Buffer data) {
        Completable ret = this.rxEnd(data);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd(io.vertx.rxjava3.core.buffer.Buffer data) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end((Object)data.getDelegate(), handler));
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<io.vertx.rxjava3.core.buffer.Buffer> pipe() {
        Pipe<io.vertx.rxjava3.core.buffer.Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<io.vertx.rxjava3.core.buffer.Buffer> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    @Override
    public NetSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public NetSocket handler(Handler<io.vertx.rxjava3.core.buffer.Buffer> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> io.vertx.rxjava3.core.buffer.Buffer.newInstance(event)));
        return this;
    }

    public NetSocket pause() {
        this.delegate.pause();
        return this;
    }

    public NetSocket resume() {
        this.delegate.resume();
        return this;
    }

    public NetSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public NetSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public NetSocket setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public NetSocket drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }

    public String writeHandlerID() {
        String ret = this.delegate.writeHandlerID();
        return ret;
    }

    @Override
    public Completable write(String str) {
        Completable ret = this.rxWrite(str);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(String str) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(str, handler));
    }

    public Completable write(String str, String enc) {
        Completable ret = this.rxWrite(str, enc);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxWrite(String str, String enc) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(str, enc, handler));
    }

    @Override
    public Completable write(io.vertx.rxjava3.core.buffer.Buffer message) {
        Completable ret = this.rxWrite(message);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxWrite(io.vertx.rxjava3.core.buffer.Buffer message) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.write(message.getDelegate(), handler));
    }

    public Completable sendFile(String filename) {
        Completable ret = this.rxSendFile(filename);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, resultHandler));
    }

    public Completable sendFile(String filename, long offset) {
        Completable ret = this.rxSendFile(filename, offset);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, offset, resultHandler));
    }

    public Completable sendFile(String filename, long offset, long length) {
        Completable ret = this.rxSendFile(filename, offset, length);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSendFile(String filename, long offset, long length) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.sendFile(filename, offset, length, resultHandler));
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.remoteAddress());
        return ret;
    }

    public SocketAddress remoteAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.remoteAddress(real));
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public SocketAddress localAddress(boolean real) {
        SocketAddress ret = SocketAddress.newInstance(this.delegate.localAddress(real));
        return ret;
    }

    @Override
    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public NetSocket closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Completable upgradeToSsl() {
        Completable ret = this.rxUpgradeToSsl();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.upgradeToSsl(handler));
    }

    public Completable upgradeToSsl(String serverName) {
        Completable ret = this.rxUpgradeToSsl(serverName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUpgradeToSsl(String serverName) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.upgradeToSsl(serverName, handler));
    }

    public boolean isSsl() {
        boolean ret = this.delegate.isSsl();
        return ret;
    }

    public String indicatedServerName() {
        String ret = this.delegate.indicatedServerName();
        return ret;
    }

    public String applicationLayerProtocol() {
        String ret = this.delegate.applicationLayerProtocol();
        return ret;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
        return arg != null ? new NetSocket(arg) : null;
    }
}

