/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.mongo;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.AggregateOptions;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.CountOptions;
import io.vertx.ext.mongo.CreateCollectionOptions;
import io.vertx.ext.mongo.DistinctOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexModel;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.ext.mongo.MongoGridFsClient;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoClient.class)
public class MongoClient
implements RxDelegate {
    public static final TypeArg<MongoClient> __TYPE_ARG = new TypeArg(obj -> new MongoClient((io.vertx.ext.mongo.MongoClient)obj), MongoClient::getDelegate);
    private final io.vertx.ext.mongo.MongoClient delegate;
    public static final String DEFAULT_POOL_NAME = "DEFAULT_POOL";
    public static final String DEFAULT_DB_NAME = "DEFAULT_DB";

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoClient that = (MongoClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public MongoClient(io.vertx.ext.mongo.MongoClient delegate) {
        this.delegate = delegate;
    }

    public MongoClient(Object delegate) {
        this.delegate = (io.vertx.ext.mongo.MongoClient)delegate;
    }

    public io.vertx.ext.mongo.MongoClient getDelegate() {
        return this.delegate;
    }

    public static MongoClient create(io.vertx.rxjava3.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.create((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava3.core.Vertx vertx, JsonObject config, String dataSourceName) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config, (String)dataSourceName));
        return ret;
    }

    public static MongoClient createShared(io.vertx.rxjava3.core.Vertx vertx, JsonObject config) {
        MongoClient ret = MongoClient.newInstance(io.vertx.ext.mongo.MongoClient.createShared((Vertx)vertx.getDelegate(), (JsonObject)config));
        return ret;
    }

    public Maybe<String> save(String collection, JsonObject document) {
        Maybe ret = this.rxSave(collection, document);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxSave(String collection, JsonObject document) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.save(collection, document, resultHandler));
    }

    public Maybe<String> saveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        Maybe ret = this.rxSaveWithOptions(collection, document, writeOption);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.saveWithOptions(collection, document, writeOption, resultHandler));
    }

    public Maybe<String> insert(String collection, JsonObject document) {
        Maybe ret = this.rxInsert(collection, document);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxInsert(String collection, JsonObject document) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.insert(collection, document, resultHandler));
    }

    public Maybe<String> insertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        Maybe ret = this.rxInsertWithOptions(collection, document, writeOption);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.insertWithOptions(collection, document, writeOption, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonObject update) {
        Maybe ret = this.rxUpdateCollection(collection, query, update);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.updateCollection(collection, query, update, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> updateCollection(String collection, JsonObject query, JsonArray update) {
        Maybe ret = this.rxUpdateCollection(collection, query, update);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonArray update) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.updateCollection(collection, query, update, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        Maybe ret = this.rxUpdateCollectionWithOptions(collection, query, update, options);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> updateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        Maybe ret = this.rxUpdateCollectionWithOptions(collection, query, update, options);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonArray update, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> replaceDocuments(String collection, JsonObject query, JsonObject replace) {
        Maybe ret = this.rxReplaceDocuments(collection, query, replace);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.replaceDocuments(collection, query, replace, resultHandler));
    }

    public Maybe<MongoClientUpdateResult> replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        Maybe ret = this.rxReplaceDocumentsWithOptions(collection, query, replace, options);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler));
    }

    public Maybe<MongoClientBulkWriteResult> bulkWrite(String collection, List<BulkOperation> operations) {
        Maybe ret = this.rxBulkWrite(collection, operations);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.bulkWrite(collection, operations, resultHandler));
    }

    public Maybe<MongoClientBulkWriteResult> bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        Maybe ret = this.rxBulkWriteWithOptions(collection, operations, bulkWriteOptions);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler));
    }

    public Single<List<JsonObject>> find(String collection, JsonObject query) {
        Single ret = this.rxFind(collection, query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<JsonObject>> rxFind(String collection, JsonObject query) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.find(collection, query, resultHandler));
    }

    public ReadStream<JsonObject> findBatch(String collection, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatch(collection, query), TypeArg.unknown());
        return ret;
    }

    public Single<List<JsonObject>> findWithOptions(String collection, JsonObject query, FindOptions options) {
        Single ret = this.rxFindWithOptions(collection, query, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.findWithOptions(collection, query, options, resultHandler));
    }

    public ReadStream<JsonObject> findBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.findBatchWithOptions(collection, query, options), TypeArg.unknown());
        return ret;
    }

    public Maybe<JsonObject> findOne(String collection, JsonObject query, JsonObject fields) {
        Maybe ret = this.rxFindOne(collection, query, fields);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOne(collection, query, fields, resultHandler));
    }

    public Maybe<JsonObject> findOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        Maybe ret = this.rxFindOneAndUpdate(collection, query, update);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndUpdate(collection, query, update, resultHandler));
    }

    public Maybe<JsonObject> findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        Maybe ret = this.rxFindOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler));
    }

    public Maybe<JsonObject> findOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        Maybe ret = this.rxFindOneAndReplace(collection, query, replace);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndReplace(collection, query, replace, resultHandler));
    }

    public Maybe<JsonObject> findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        Maybe ret = this.rxFindOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject replace, FindOptions findOptions, UpdateOptions updateOptions) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndReplaceWithOptions(collection, query, replace, findOptions, updateOptions, resultHandler));
    }

    public Maybe<JsonObject> findOneAndDelete(String collection, JsonObject query) {
        Maybe ret = this.rxFindOneAndDelete(collection, query);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndDelete(collection, query, resultHandler));
    }

    public Maybe<JsonObject> findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        Maybe ret = this.rxFindOneAndDeleteWithOptions(collection, query, findOptions);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler));
    }

    public Single<Long> count(String collection, JsonObject query) {
        Single ret = this.rxCount(collection, query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxCount(String collection, JsonObject query) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.count(collection, query, resultHandler));
    }

    public Single<Long> countWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        Single ret = this.rxCountWithOptions(collection, query, countOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Long> rxCountWithOptions(String collection, JsonObject query, CountOptions countOptions) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.countWithOptions(collection, query, countOptions, resultHandler));
    }

    public Maybe<MongoClientDeleteResult> removeDocuments(String collection, JsonObject query) {
        Maybe ret = this.rxRemoveDocuments(collection, query);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.removeDocuments(collection, query, resultHandler));
    }

    public Maybe<MongoClientDeleteResult> removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        Maybe ret = this.rxRemoveDocumentsWithOptions(collection, query, writeOption);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler));
    }

    public Maybe<MongoClientDeleteResult> removeDocument(String collection, JsonObject query) {
        Maybe ret = this.rxRemoveDocument(collection, query);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.removeDocument(collection, query, resultHandler));
    }

    public Maybe<MongoClientDeleteResult> removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        Maybe ret = this.rxRemoveDocumentWithOptions(collection, query, writeOption);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler));
    }

    public Completable createCollection(String collectionName) {
        Completable ret = this.rxCreateCollection(collectionName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateCollection(String collectionName) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.createCollection(collectionName, resultHandler));
    }

    public Completable createCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        Completable ret = this.rxCreateCollectionWithOptions(collectionName, collectionOptions);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateCollectionWithOptions(String collectionName, CreateCollectionOptions collectionOptions) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.createCollectionWithOptions(collectionName, collectionOptions, resultHandler));
    }

    public Single<List<String>> getCollections() {
        Single ret = this.rxGetCollections();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxGetCollections() {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.getCollections(resultHandler));
    }

    public Completable dropCollection(String collection) {
        Completable ret = this.rxDropCollection(collection);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDropCollection(String collection) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.dropCollection(collection, resultHandler));
    }

    public Completable createIndex(String collection, JsonObject key) {
        Completable ret = this.rxCreateIndex(collection, key);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateIndex(String collection, JsonObject key) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.createIndex(collection, key, resultHandler));
    }

    public Completable createIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        Completable ret = this.rxCreateIndexWithOptions(collection, key, options);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.createIndexWithOptions(collection, key, options, resultHandler));
    }

    public Completable createIndexes(String collection, List<IndexModel> indexes) {
        Completable ret = this.rxCreateIndexes(collection, indexes);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxCreateIndexes(String collection, List<IndexModel> indexes) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.createIndexes(collection, indexes, resultHandler));
    }

    public Single<JsonArray> listIndexes(String collection) {
        Single ret = this.rxListIndexes(collection);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonArray> rxListIndexes(String collection) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.listIndexes(collection, resultHandler));
    }

    public Completable dropIndex(String collection, String indexName) {
        Completable ret = this.rxDropIndex(collection, indexName);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxDropIndex(String collection, String indexName) {
        return AsyncResultCompletable.toCompletable(resultHandler -> this.delegate.dropIndex(collection, indexName, resultHandler));
    }

    public Maybe<JsonObject> runCommand(String commandName, JsonObject command) {
        Maybe ret = this.rxRunCommand(commandName, command);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<JsonObject> rxRunCommand(String commandName, JsonObject command) {
        return AsyncResultMaybe.toMaybe(resultHandler -> this.delegate.runCommand(commandName, command, resultHandler));
    }

    public Single<JsonArray> distinct(String collection, String fieldName, String resultClassname) {
        Single ret = this.rxDistinct(collection, fieldName, resultClassname);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.distinct(collection, fieldName, resultClassname, resultHandler));
    }

    public Single<JsonArray> distinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        Single ret = this.rxDistinct(collection, fieldName, resultClassname, distinctOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.distinct(collection, fieldName, resultClassname, distinctOptions, resultHandler));
    }

    public Single<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        Single ret = this.rxDistinctWithQuery(collection, fieldName, resultClassname, query);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler));
    }

    public Single<JsonArray> distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        Single ret = this.rxDistinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.distinctWithQuery(collection, fieldName, resultClassname, query, distinctOptions, resultHandler));
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatch(String collection, String fieldName, String resultClassname, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatch(collection, fieldName, resultClassname, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> distinctBatchWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, int batchSize, DistinctOptions distinctOptions) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.distinctBatchWithQuery(collection, fieldName, resultClassname, query, batchSize, distinctOptions), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregate(String collection, JsonArray pipeline) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregate(collection, pipeline), TypeArg.unknown());
        return ret;
    }

    public ReadStream<JsonObject> aggregateWithOptions(String collection, JsonArray pipeline, AggregateOptions options) {
        ReadStream<JsonObject> ret = ReadStream.newInstance(this.delegate.aggregateWithOptions(collection, pipeline, options), TypeArg.unknown());
        return ret;
    }

    public Single<MongoGridFsClient> createDefaultGridFsBucketService() {
        Single ret = this.rxCreateDefaultGridFsBucketService();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<MongoGridFsClient> rxCreateDefaultGridFsBucketService() {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.createDefaultGridFsBucketService(Helper.convertHandler((Handler)resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event)))));
    }

    public Single<MongoGridFsClient> createGridFsBucketService(String bucketName) {
        Single ret = this.rxCreateGridFsBucketService(bucketName);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<MongoGridFsClient> rxCreateGridFsBucketService(String bucketName) {
        return AsyncResultSingle.toSingle(resultHandler -> this.delegate.createGridFsBucketService(bucketName, Helper.convertHandler((Handler)resultHandler, ar -> ar.map(event -> MongoGridFsClient.newInstance(event)))));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public ReadStream<ChangeStreamDocument<JsonObject>> watch(String collection, JsonArray pipeline, boolean withUpdatedDoc, int batchSize) {
        ReadStream<ChangeStreamDocument<JsonObject>> ret = ReadStream.newInstance(this.delegate.watch(collection, pipeline, withUpdatedDoc, batchSize), TypeArg.unknown());
        return ret;
    }

    public static MongoClient newInstance(io.vertx.ext.mongo.MongoClient arg) {
        return arg != null ? new MongoClient(arg) : null;
    }
}

