/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.sqlclient.templates;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An SQL template.
 *
 * <p>SQL templates are useful for interacting with a relational database.
 *
 * <p>SQL templates execute queries using named instead of positional parameters. Query execution is parameterized
 * by a map of string to objects instead of a {@link io.vertx.rxjava3.sqlclient.Tuple}. The default source of parameters is a
 * simple map, a user defined mapping can be used instead given it maps the source to such a map.
 *
 * <p>SQL template default results are , a user defined mapping can be used instead, mapping the
 * result set  to a  of the mapped type.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.templates.SqlTemplate original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.templates.SqlTemplate.class)
public class SqlTemplate<I,R> implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlTemplate that = (SqlTemplate) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlTemplate> __TYPE_ARG = new TypeArg<>(    obj -> new SqlTemplate((io.vertx.sqlclient.templates.SqlTemplate) obj),
    SqlTemplate::getDelegate
  );

  private final io.vertx.sqlclient.templates.SqlTemplate<I,R> delegate;
  public final TypeArg<I> __typeArg_0;
  public final TypeArg<R> __typeArg_1;
  
  public SqlTemplate(io.vertx.sqlclient.templates.SqlTemplate delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();    this.__typeArg_1 = TypeArg.unknown();  }

  public SqlTemplate(Object delegate, TypeArg<I> typeArg_0, TypeArg<R> typeArg_1) {
    this.delegate = (io.vertx.sqlclient.templates.SqlTemplate)delegate;
    this.__typeArg_0 = typeArg_0;
    this.__typeArg_1 = typeArg_1;
  }

  @Override 
  public io.vertx.sqlclient.templates.SqlTemplate getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>>(o1 -> io.vertx.rxjava3.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava3.sqlclient.Row>(o2 -> io.vertx.rxjava3.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava3.sqlclient.SqlResult<java.lang.Void>> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava3.sqlclient.SqlResult<java.lang.Void>>(o1 -> io.vertx.rxjava3.sqlclient.SqlResult.newInstance((io.vertx.sqlclient.SqlResult)o1, TypeArg.unknown()), o1 -> o1.getDelegate());

  /**
   * Create an SQL template for query purpose consuming map parameters and returning .
   * @param client the wrapped SQL client
   * @param template the template query string
   * @return the template
   */
  public static io.vertx.rxjava3.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> forQuery(io.vertx.rxjava3.sqlclient.SqlClient client, java.lang.String template) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.rxjava3.sqlclient.RowSet<io.vertx.rxjava3.sqlclient.Row>> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forQuery(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Create an SQL template for query purpose consuming map parameters and returning void.
   * @param client the wrapped SQL client
   * @param template the template update string
   * @return the template
   */
  public static io.vertx.rxjava3.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.rxjava3.sqlclient.SqlResult<java.lang.Void>> forUpdate(io.vertx.rxjava3.sqlclient.SqlClient client, java.lang.String template) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<java.util.Map<java.lang.String,java.lang.Object>,io.vertx.rxjava3.sqlclient.SqlResult<java.lang.Void>> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)io.vertx.sqlclient.templates.SqlTemplate.forUpdate(client.getDelegate(), template), TypeArg.unknown(), TYPE_ARG_1);
    return ret;
  }

  /**
   * Set a parameters user defined mapping function.
   *
   * <p> At query execution, the <code>mapper</code> is called to map the parameters object
   * to a <code>Tuple</code> that configures the prepared query.
   * @param mapper the mapping function
   * @return a new template
   */
  public <T> io.vertx.rxjava3.sqlclient.templates.SqlTemplate<T,R> mapFrom(io.vertx.rxjava3.sqlclient.templates.TupleMapper<T> mapper) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<T,R> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(mapper.getDelegate()), mapper.__typeArg_0, __typeArg_1);
    return ret;
  }

  /**
   * Set a parameters user defined class mapping.
   *
   * <p> At query execution, the parameters object is is mapped to a <code>Map<String, Object></code> that
   * configures the prepared query.
   *
   * <p> This feature relies on {@link io.vertx.core.json.JsonObject} feature. This likely requires
   * to use Jackson databind in the project.
   * @param type the mapping type
   * @return a new template
   */
  public <T> io.vertx.rxjava3.sqlclient.templates.SqlTemplate<T,R> mapFrom(java.lang.Class<T> type) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<T,R> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapFrom(io.vertx.lang.rxjava3.Helper.unwrap(type)), TypeArg.of(type), __typeArg_1);
    return ret;
  }

  /**
   * Set a row user defined mapping function.
   *
   * <p> When the query execution completes, the <code>mapper</code> function is called to map the resulting
   * rows to objects.
   * @param mapper the mapping function
   * @return a new template
   */
  public <U> io.vertx.rxjava3.sqlclient.templates.SqlTemplate<I,io.vertx.rxjava3.sqlclient.RowSet<U>> mapTo(io.vertx.rxjava3.sqlclient.templates.RowMapper<U> mapper) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<I,io.vertx.rxjava3.sqlclient.RowSet<U>> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(mapper.getDelegate()), __typeArg_0, new TypeArg<io.vertx.rxjava3.sqlclient.RowSet<U>>(o0 -> io.vertx.rxjava3.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, mapper.__typeArg_0), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Set a row user defined mapping function.
   *
   * <p> When the query execution completes, resulting rows are mapped to <code>type</code> instances.
   *
   * <p> This feature relies on {@link io.vertx.core.json.JsonObject} feature. This likely requires
   * to use Jackson databind in the project.
   * @param type the mapping type
   * @return a new template
   */
  public <U> io.vertx.rxjava3.sqlclient.templates.SqlTemplate<I,io.vertx.rxjava3.sqlclient.RowSet<U>> mapTo(java.lang.Class<U> type) { 
    io.vertx.rxjava3.sqlclient.templates.SqlTemplate<I,io.vertx.rxjava3.sqlclient.RowSet<U>> ret = io.vertx.rxjava3.sqlclient.templates.SqlTemplate.newInstance((io.vertx.sqlclient.templates.SqlTemplate)delegate.mapTo(io.vertx.lang.rxjava3.Helper.unwrap(type)), __typeArg_0, new TypeArg<io.vertx.rxjava3.sqlclient.RowSet<U>>(o0 -> io.vertx.rxjava3.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.of(type)), o0 -> o0.getDelegate()));
    return ret;
  }

  /**
   * Execute the query with the <code>parameters</code>
   * @param parameters the query parameters
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<R> execute(I parameters) { 
    io.reactivex.rxjava3.core.Single<R> ret = rxExecute(parameters);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute the query with the <code>parameters</code>
   * @param parameters the query parameters
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<R> rxExecute(I parameters) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.execute(__typeArg_0.<I>unwrap(parameters), io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> (R)__typeArg_1.wrap(event))));
    });
  }

  /**
   * Execute a batch query with the <code>batch</code>.
   *
   * <p>Each item in the batch is mapped to a tuple.
   * @param batch the batch
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<R> executeBatch(java.util.List<I> batch) { 
    io.reactivex.rxjava3.core.Single<R> ret = rxExecuteBatch(batch);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Execute a batch query with the <code>batch</code>.
   *
   * <p>Each item in the batch is mapped to a tuple.
   * @param batch the batch
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<R> rxExecuteBatch(java.util.List<I> batch) { 
    return AsyncResultSingle.toSingle( handler -> {
      delegate.executeBatch(batch.stream().map(elt -> __typeArg_0.<I>unwrap(elt)).collect(Collectors.toList()), io.vertx.lang.rxjava3.Helper.convertHandler(handler, ar -> ar.map(event -> (R)__typeArg_1.wrap(event))));
    });
  }

  public static <I,R> SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg) {
    return arg != null ? new SqlTemplate<I,R>(arg) : null;
  }

  public static <I,R> SqlTemplate<I,R> newInstance(io.vertx.sqlclient.templates.SqlTemplate arg, TypeArg<I> __typeArg_I, TypeArg<R> __typeArg_R) {
    return arg != null ? new SqlTemplate<I,R>(arg, __typeArg_I, __typeArg_R) : null;
  }

}
