/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.oracleclient;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Entry point for building Oracle clients.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleBuilder original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.oracleclient.OracleBuilder.class)
public class OracleBuilder implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OracleBuilder that = (OracleBuilder) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OracleBuilder> __TYPE_ARG = new TypeArg<>(    obj -> new OracleBuilder((io.vertx.oracleclient.OracleBuilder) obj),
    OracleBuilder::getDelegate
  );

  private final io.vertx.oracleclient.OracleBuilder delegate;
  
  public OracleBuilder(io.vertx.oracleclient.OracleBuilder delegate) {
    this.delegate = delegate;
  }

  public OracleBuilder(Object delegate) {
    this.delegate = (io.vertx.oracleclient.OracleBuilder)delegate;
  }

  @Override 
  public io.vertx.oracleclient.OracleBuilder getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.sqlclient.Pool> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.sqlclient.Pool>(o1 -> io.vertx.rxjava3.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o1), o1 -> o1.getDelegate());

  /**
   * Build a pool with the specified <code>block</code> argument.
   * The <code>block</code> argument is usually a lambda that configures the provided builder
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool(builder -> builder.connectingTo(connectOptions));</code>
   * @param block 
   * @return the pool as configured by the code <code>block</code>
   */
  public static io.vertx.rxjava3.sqlclient.Pool pool(io.vertx.core.Handler<io.vertx.rxjava3.sqlclient.ClientBuilder<io.vertx.rxjava3.sqlclient.Pool>> block) { 
    io.vertx.rxjava3.sqlclient.Pool ret = io.vertx.rxjava3.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.oracleclient.OracleBuilder.pool(io.vertx.lang.rxjava3.Helper.convertHandler(block, event -> io.vertx.rxjava3.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)event, new TypeArg<io.vertx.rxjava3.sqlclient.Pool>(o0 -> io.vertx.rxjava3.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)o0), o0 -> o0.getDelegate())))));
    return ret;
  }

  /**
   * Provide a builder for Oracle pool of connections
   * <p>
   * Example usage: <code>Pool pool = PgBuilder.pool().connectingTo(connectOptions).build()</code>
   * @return 
   */
  public static io.vertx.rxjava3.sqlclient.ClientBuilder<io.vertx.rxjava3.sqlclient.Pool> pool() { 
    io.vertx.rxjava3.sqlclient.ClientBuilder<io.vertx.rxjava3.sqlclient.Pool> ret = io.vertx.rxjava3.sqlclient.ClientBuilder.newInstance((io.vertx.sqlclient.ClientBuilder)io.vertx.oracleclient.OracleBuilder.pool(), TYPE_ARG_0);
    return ret;
  }

  public static OracleBuilder newInstance(io.vertx.oracleclient.OracleBuilder arg) {
    return arg != null ? new OracleBuilder(arg) : null;
  }

}
