/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.openapi.contract;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This interface represents the most important attributes of an OpenAPI Parameter.
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.0.md#parameter-Object">Parameter V3.1</a>
 * <br>
 * <a href="https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.3.md#parameter-Object">Parameter V3.0</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.openapi.contract.Parameter original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.openapi.contract.Parameter.class)
public class Parameter implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Parameter that = (Parameter) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Parameter> __TYPE_ARG = new TypeArg<>(    obj -> new Parameter((io.vertx.openapi.contract.Parameter) obj),
    Parameter::getDelegate
  );

  private final io.vertx.openapi.contract.Parameter delegate;
  
  public Parameter(io.vertx.openapi.contract.Parameter delegate) {
    this.delegate = delegate;
  }

  public Parameter(Object delegate) {
    this.delegate = (io.vertx.openapi.contract.Parameter)delegate;
  }

  @Override 
  public io.vertx.openapi.contract.Parameter getDelegate() {
    return delegate;
  }

  /**
   * @return name of this parameter
   */
  public java.lang.String getName() { 
    java.lang.String ret = delegate.getName();
    return ret;
  }

  /**
   * @return location of this parameter
   */
  public io.vertx.openapi.contract.Location getIn() { 
    io.vertx.openapi.contract.Location ret = delegate.getIn();
    return ret;
  }

  /**
   * @return true if the parameter is required, otherwise false;
   */
  public boolean isRequired() { 
    boolean ret = delegate.isRequired();
    return ret;
  }

  /**
   * @return style of this parameter
   */
  public io.vertx.openapi.contract.Style getStyle() { 
    io.vertx.openapi.contract.Style ret = delegate.getStyle();
    return ret;
  }

  /**
   * @return true if the parameter should become exploded, otherwise false;
   */
  public boolean isExplode() { 
    boolean ret = delegate.isExplode();
    return ret;
  }

  /**
   * @return the  of the parameter
   */
  public io.vertx.rxjava3.json.schema.JsonSchema getSchema() { 
    io.vertx.rxjava3.json.schema.JsonSchema ret = io.vertx.rxjava3.json.schema.JsonSchema.newInstance((io.vertx.json.schema.JsonSchema)delegate.getSchema());
    return ret;
  }

  /**
   * @return the  of the parameter
   */
  public io.vertx.json.schema.common.dsl.SchemaType getSchemaType() { 
    io.vertx.json.schema.common.dsl.SchemaType ret = delegate.getSchemaType();
    return ret;
  }

  public static Parameter newInstance(io.vertx.openapi.contract.Parameter arg) {
    return arg != null ? new Parameter(arg) : null;
  }

}
