/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.mqtt;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An MQTT server
 * <p>
 *    You can accept incoming MQTT connection requests providing a {@link io.vertx.rxjava3.mqtt.MqttServer#endpointHandler}. As the
 *    requests arrive, the handler will be called with an instance of {@link io.vertx.rxjava3.mqtt.MqttEndpoint} in order to manage the
 *    communication with the remote MQTT client.
 * </p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mqtt.MqttServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mqtt.MqttServer.class)
public class MqttServer implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MqttServer that = (MqttServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MqttServer> __TYPE_ARG = new TypeArg<>(    obj -> new MqttServer((io.vertx.mqtt.MqttServer) obj),
    MqttServer::getDelegate
  );

  private final io.vertx.mqtt.MqttServer delegate;
  
  public MqttServer(io.vertx.mqtt.MqttServer delegate) {
    this.delegate = delegate;
  }

  public MqttServer(Object delegate) {
    this.delegate = (io.vertx.mqtt.MqttServer)delegate;
  }

  @Override 
  public io.vertx.mqtt.MqttServer getDelegate() {
    return delegate;
  }

  /**
   * Return an MQTT server instance
   * @param vertx Vert.x instance
   * @param options MQTT server options
   * @return MQTT server instance
   */
  public static io.vertx.rxjava3.mqtt.MqttServer create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.mqtt.MqttServerOptions options) { 
    io.vertx.rxjava3.mqtt.MqttServer ret = io.vertx.rxjava3.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Return an MQTT server instance using default options
   * @param vertx Vert.x instance
   * @return MQTT server instance
   */
  public static io.vertx.rxjava3.mqtt.MqttServer create(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.mqtt.MqttServer ret = io.vertx.rxjava3.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)io.vertx.mqtt.MqttServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * It ignores any options specified through the constructor
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> listen(int port, java.lang.String host) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> ret = rxListen(port, host);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Start the server listening for incoming connections on the port and host specified
   * It ignores any options specified through the constructor
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> rxListen(int port, java.lang.String host) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, host, io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> listen(int port) { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> ret = rxListen(port);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Start the server listening for incoming connections on the port specified but on
   * "0.0.0.0" as host. It ignores any options specified through the constructor
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> rxListen(int port) { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(port, io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> listen() { 
    io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> ret = rxListen();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Start the server listening for incoming connections using the specified options
   * through the constructor
   * @return a reference to this, so the API can be used fluently
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.rxjava3.mqtt.MqttServer> rxListen() { 
    return AsyncResultSingle.toSingle( listenHandler -> {
      delegate.listen(io.vertx.lang.rxjava3.Helper.convertHandler(listenHandler, ar -> ar.map(event -> io.vertx.rxjava3.mqtt.MqttServer.newInstance((io.vertx.mqtt.MqttServer)event))));
    });
  }

  /**
   * Set the endpoint handler for the server. If an MQTT client connect to the server a
   * new MqttEndpoint instance will be created and passed to the handler
   * @param handler the endpoint handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttServer endpointHandler(io.vertx.core.Handler<io.vertx.rxjava3.mqtt.MqttEndpoint> handler) { 
    delegate.endpointHandler(io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.mqtt.MqttEndpoint.newInstance((io.vertx.mqtt.MqttEndpoint)event)));
    return this;
  }

  /**
   * Set an exception handler for the server, that will be called when an error happens independantly of an
   * accepted {@link io.vertx.rxjava3.mqtt.MqttEndpoint}, like a rejected connection
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.mqtt.MqttServer exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  /**
   * Close the server supplying an handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable close() { 
    io.reactivex.rxjava3.core.Completable ret = rxClose();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Close the server supplying an handler that will be called when the server is actually closed (or has failed).
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxClose() { 
    return AsyncResultCompletable.toCompletable( completionHandler -> {
      delegate.close(completionHandler);
    });
  }

  public static MqttServer newInstance(io.vertx.mqtt.MqttServer arg) {
    return arg != null ? new MqttServer(arg) : null;
  }

}
