/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.grpcio.server;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * <p>Extends the  so it can be utilized with .</p>
 *
 * <p>In Vert.x 5, the core  is decoupled from `io.grpc.*` packages to support JPMS.</p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.grpcio.server.GrpcIoServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.grpcio.server.GrpcIoServer.class)
public class GrpcIoServer extends io.vertx.rxjava3.grpc.server.GrpcServer implements RxDelegate, Handler<io.vertx.rxjava3.core.http.HttpServerRequest> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GrpcIoServer that = (GrpcIoServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GrpcIoServer> __TYPE_ARG = new TypeArg<>(    obj -> new GrpcIoServer((io.vertx.grpcio.server.GrpcIoServer) obj),
    GrpcIoServer::getDelegate
  );

  private final io.vertx.grpcio.server.GrpcIoServer delegate;
  
  public GrpcIoServer(io.vertx.grpcio.server.GrpcIoServer delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public GrpcIoServer(Object delegate) {
    super((io.vertx.grpcio.server.GrpcIoServer)delegate);
    this.delegate = (io.vertx.grpcio.server.GrpcIoServer)delegate;
  }

  @Override 
  public io.vertx.grpcio.server.GrpcIoServer getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.core.http.HttpServerRequest event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a blank gRPC/IO server
   * @param vertx the vertx instance
   * @return the created server
   */
  public static io.vertx.rxjava3.grpcio.server.GrpcIoServer server(io.vertx.rxjava3.core.Vertx vertx) { 
    io.vertx.rxjava3.grpcio.server.GrpcIoServer ret = io.vertx.rxjava3.grpcio.server.GrpcIoServer.newInstance((io.vertx.grpcio.server.GrpcIoServer)io.vertx.grpcio.server.GrpcIoServer.server(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a blank gRPC/IO server
   * @param vertx the vertx instance
   * @param options the server options
   * @return the created server
   */
  public static io.vertx.rxjava3.grpcio.server.GrpcIoServer server(io.vertx.rxjava3.core.Vertx vertx, io.vertx.grpc.server.GrpcServerOptions options) { 
    io.vertx.rxjava3.grpcio.server.GrpcIoServer ret = io.vertx.rxjava3.grpcio.server.GrpcIoServer.newInstance((io.vertx.grpcio.server.GrpcIoServer)io.vertx.grpcio.server.GrpcIoServer.server(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Set a service method call handler that handles any call made to the server for the  service method.
   * @param methodDesc 
   * @param handler the service method call handler
   * @return a reference to this, so the API can be used fluently
   */
  public <Req, Resp> io.vertx.rxjava3.grpcio.server.GrpcIoServer callHandler(io.grpc.MethodDescriptor<Req,Resp> methodDesc, io.vertx.core.Handler<io.vertx.rxjava3.grpc.server.GrpcServerRequest<Req,Resp>> handler) { 
    io.vertx.rxjava3.grpcio.server.GrpcIoServer ret = io.vertx.rxjava3.grpcio.server.GrpcIoServer.newInstance((io.vertx.grpcio.server.GrpcIoServer)delegate.callHandler(methodDesc, io.vertx.lang.rxjava3.Helper.convertHandler(handler, event -> io.vertx.rxjava3.grpc.server.GrpcServerRequest.newInstance((io.vertx.grpc.server.GrpcServerRequest)event, TypeArg.unknown(), TypeArg.unknown()))));
    return ret;
  }

  public static GrpcIoServer newInstance(io.vertx.grpcio.server.GrpcIoServer arg) {
    return arg != null ? new GrpcIoServer(arg) : null;
  }

}
