/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.sstore.redis;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A SessionStore that uses a Redis to store the sessions and associated data.
 * This assumes that the redis logical database (i.e. select) is only used
 * to store the sessions to make size query reliable.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.sstore.redis.RedisSessionStore original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.sstore.redis.RedisSessionStore.class)
public class RedisSessionStore extends io.vertx.rxjava3.ext.web.sstore.SessionStore implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisSessionStore that = (RedisSessionStore) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisSessionStore> __TYPE_ARG = new TypeArg<>(    obj -> new RedisSessionStore((io.vertx.ext.web.sstore.redis.RedisSessionStore) obj),
    RedisSessionStore::getDelegate
  );

  private final io.vertx.ext.web.sstore.redis.RedisSessionStore delegate;
  
  public RedisSessionStore(io.vertx.ext.web.sstore.redis.RedisSessionStore delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public RedisSessionStore(Object delegate) {
    super((io.vertx.ext.web.sstore.redis.RedisSessionStore)delegate);
    this.delegate = (io.vertx.ext.web.sstore.redis.RedisSessionStore)delegate;
  }

  @Override 
  public io.vertx.ext.web.sstore.redis.RedisSessionStore getDelegate() {
    return delegate;
  }

  /**
   * Creates a RedisSessionStore with the default retry TO.
   * @param vertx a Vert.x instance
   * @param redis A Redis client
   * @return the store
   */
  public static io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.rxjava3.redis.client.Redis redis) { 
    io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore ret = io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore.newInstance((io.vertx.ext.web.sstore.redis.RedisSessionStore)io.vertx.ext.web.sstore.redis.RedisSessionStore.create(vertx.getDelegate(), redis.getDelegate()));
    return ret;
  }

  /**
   * Creates a RedisSessionStore with the given retry TO.
   * @param vertx a Vert.x instance
   * @param retryTimeoutMs The time between two consecutive tries
   * @param redis The given options to establish the connection
   * @return the store
   */
  public static io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore create(io.vertx.rxjava3.core.Vertx vertx, long retryTimeoutMs, io.vertx.rxjava3.redis.client.Redis redis) { 
    io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore ret = io.vertx.rxjava3.ext.web.sstore.redis.RedisSessionStore.newInstance((io.vertx.ext.web.sstore.redis.RedisSessionStore)io.vertx.ext.web.sstore.redis.RedisSessionStore.create(vertx.getDelegate(), retryTimeoutMs, redis.getDelegate()));
    return ret;
  }

  /**
   * Default length for a session id.
   * More info: https://www.owasp.org/index.php/Session_Management_Cheat_Sheet
   */
  public static final int DEFAULT_SESSIONID_LENGTH = io.vertx.ext.web.sstore.redis.RedisSessionStore.DEFAULT_SESSIONID_LENGTH;
  public static final long DEFAULT_RETRY_TIMEOUT_MS = io.vertx.ext.web.sstore.redis.RedisSessionStore.DEFAULT_RETRY_TIMEOUT_MS;
  public static RedisSessionStore newInstance(io.vertx.ext.web.sstore.redis.RedisSessionStore arg) {
    return arg != null ? new RedisSessionStore(arg) : null;
  }

}
