/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.multipart;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A multipart form.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.multipart.MultipartForm original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.multipart.MultipartForm.class)
public class MultipartForm implements RxDelegate, Iterable<io.vertx.rxjava3.ext.web.multipart.FormDataPart> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MultipartForm that = (MultipartForm) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @Override
  public Iterator<io.vertx.rxjava3.ext.web.multipart.FormDataPart> iterator() {
    Function<io.vertx.ext.web.multipart.FormDataPart, io.vertx.rxjava3.ext.web.multipart.FormDataPart> conv = io.vertx.rxjava3.ext.web.multipart.FormDataPart::newInstance;
    return new MappingIterator<>(delegate.iterator(), conv);
  }

  public static final TypeArg<MultipartForm> __TYPE_ARG = new TypeArg<>(    obj -> new MultipartForm((io.vertx.ext.web.multipart.MultipartForm) obj),
    MultipartForm::getDelegate
  );

  private final io.vertx.ext.web.multipart.MultipartForm delegate;
  
  public MultipartForm(io.vertx.ext.web.multipart.MultipartForm delegate) {
    this.delegate = delegate;
  }

  public MultipartForm(Object delegate) {
    this.delegate = (io.vertx.ext.web.multipart.MultipartForm)delegate;
  }

  @Override 
  public io.vertx.ext.web.multipart.MultipartForm getDelegate() {
    return delegate;
  }

  /**
   * @return a multipart form instance
   */
  public static io.vertx.rxjava3.ext.web.multipart.MultipartForm create() { 
    io.vertx.rxjava3.ext.web.multipart.MultipartForm ret = io.vertx.rxjava3.ext.web.multipart.MultipartForm.newInstance((io.vertx.ext.web.multipart.MultipartForm)io.vertx.ext.web.multipart.MultipartForm.create());
    return ret;
  }

  /**
   * Set the <code>charset</code> to use when encoding the form. The default charset is {@link java.nio.charset.StandardCharsets}.
   * @param charset the charset to use
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm setCharset(java.lang.String charset) { 
    delegate.setCharset(charset);
    return this;
  }

  /**
   * Add an attribute form data part.
   * @param name the name of the attribute
   * @param value the value of the attribute
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm attribute(java.lang.String name, java.lang.String value) { 
    delegate.attribute(name, value);
    return this;
  }

  /**
   * Add a text file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm textFileUpload(java.lang.String name, java.lang.String filename, java.lang.String pathname, java.lang.String mediaType) { 
    delegate.textFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  /**
   * Add a text file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param content the content of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm textFileUpload(java.lang.String name, java.lang.String filename, io.vertx.rxjava3.core.buffer.Buffer content, java.lang.String mediaType) { 
    delegate.textFileUpload(name, filename, content.getDelegate(), mediaType);
    return this;
  }

  /**
   * Add a binary file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param pathname the pathname of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm binaryFileUpload(java.lang.String name, java.lang.String filename, java.lang.String pathname, java.lang.String mediaType) { 
    delegate.binaryFileUpload(name, filename, pathname, mediaType);
    return this;
  }

  /**
   * Add a binary file upload form data part.
   * @param name name of the parameter
   * @param filename filename of the file
   * @param content the content of the file
   * @param mediaType the MIME type of the file
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm binaryFileUpload(java.lang.String name, java.lang.String filename, io.vertx.rxjava3.core.buffer.Buffer content, java.lang.String mediaType) { 
    delegate.binaryFileUpload(name, filename, content.getDelegate(), mediaType);
    return this;
  }

  /**
   * Set the <code>charset</code> to use when encoding the form. The default charset is {@link java.nio.charset.StandardCharsets}.
   * @param charset the charset to use
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.ext.web.multipart.MultipartForm setCharset(java.nio.charset.Charset charset) { 
    delegate.setCharset(charset);
    return this;
  }

  /**
   * @return the charset to use when encoding the form
   */
  public java.nio.charset.Charset getCharset() { 
    java.nio.charset.Charset ret = delegate.getCharset();
    return ret;
  }

  public static MultipartForm newInstance(io.vertx.ext.web.multipart.MultipartForm arg) {
    return arg != null ? new MultipartForm(arg) : null;
  }

}
