/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.handler;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * An auth handler that provides HTTP Basic Authentication support.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.BasicAuthHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.BasicAuthHandler.class)
public class BasicAuthHandler implements RxDelegate, io.vertx.rxjava3.ext.web.handler.AuthenticationHandler, Handler<io.vertx.rxjava3.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BasicAuthHandler that = (BasicAuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<BasicAuthHandler> __TYPE_ARG = new TypeArg<>(    obj -> new BasicAuthHandler((io.vertx.ext.web.handler.BasicAuthHandler) obj),
    BasicAuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.BasicAuthHandler delegate;
  
  public BasicAuthHandler(io.vertx.ext.web.handler.BasicAuthHandler delegate) {
    this.delegate = delegate;
  }

  public BasicAuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.BasicAuthHandler)delegate;
  }

  @Override 
  public io.vertx.ext.web.handler.BasicAuthHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava3.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a basic auth handler
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.rxjava3.ext.web.handler.BasicAuthHandler create(io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.rxjava3.ext.web.handler.BasicAuthHandler ret = io.vertx.rxjava3.ext.web.handler.BasicAuthHandler.newInstance((io.vertx.ext.web.handler.BasicAuthHandler)io.vertx.ext.web.handler.BasicAuthHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * Create a basic auth handler, specifying realm
   * @param authProvider the auth service to use
   * @param realm the realm to use
   * @return the auth handler
   */
  public static io.vertx.rxjava3.ext.web.handler.BasicAuthHandler create(io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider authProvider, java.lang.String realm) { 
    io.vertx.rxjava3.ext.web.handler.BasicAuthHandler ret = io.vertx.rxjava3.ext.web.handler.BasicAuthHandler.newInstance((io.vertx.ext.web.handler.BasicAuthHandler)io.vertx.ext.web.handler.BasicAuthHandler.create(authProvider.getDelegate(), realm));
    return ret;
  }

  /**
   * The default realm to use
   */
  public static final java.lang.String DEFAULT_REALM = io.vertx.ext.web.handler.BasicAuthHandler.DEFAULT_REALM;
  public static BasicAuthHandler newInstance(io.vertx.ext.web.handler.BasicAuthHandler arg) {
    return arg != null ? new BasicAuthHandler(arg) : null;
  }

}
