/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.shiro;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating Apache Shiro based {@link io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.shiro.ShiroAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.shiro.ShiroAuth.class)
@Deprecated()
public class ShiroAuth extends io.vertx.rxjava3.ext.auth.AuthProvider implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShiroAuth that = (ShiroAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ShiroAuth> __TYPE_ARG = new TypeArg<>(    obj -> new ShiroAuth((io.vertx.ext.auth.shiro.ShiroAuth) obj),
    ShiroAuth::getDelegate
  );

  private final io.vertx.ext.auth.shiro.ShiroAuth delegate;
  
  public ShiroAuth(io.vertx.ext.auth.shiro.ShiroAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ShiroAuth(Object delegate) {
    super((io.vertx.ext.auth.shiro.ShiroAuth)delegate);
    this.delegate = (io.vertx.ext.auth.shiro.ShiroAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.shiro.ShiroAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a Shiro auth provider
   * @param vertx the Vert.x instance
   * @param options the Shiro configuration options
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.auth.shiro.ShiroAuth create(io.vertx.rxjava3.core.Vertx vertx, io.vertx.ext.auth.shiro.ShiroAuthOptions options) { 
    io.vertx.rxjava3.ext.auth.shiro.ShiroAuth ret = io.vertx.rxjava3.ext.auth.shiro.ShiroAuth.newInstance((io.vertx.ext.auth.shiro.ShiroAuth)io.vertx.ext.auth.shiro.ShiroAuth.create(vertx.getDelegate(), options));
    return ret;
  }

  public static ShiroAuth newInstance(io.vertx.ext.auth.shiro.ShiroAuth arg) {
    return arg != null ? new ShiroAuth(arg) : null;
  }

}
