/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.oauth2.providers;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an  for GitLab.com.
 *
 * <a href="https://gitlab.com/help/api/oauth2.md">https://gitlab.com/help/api/oauth2.md</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.GitLabAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.GitLabAuth.class)
public class GitLabAuth implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitLabAuth that = (GitLabAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<GitLabAuth> __TYPE_ARG = new TypeArg<>(    obj -> new GitLabAuth((io.vertx.ext.auth.oauth2.providers.GitLabAuth) obj),
    GitLabAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.GitLabAuth delegate;
  
  public GitLabAuth(io.vertx.ext.auth.oauth2.providers.GitLabAuth delegate) {
    this.delegate = delegate;
  }

  public GitLabAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.GitLabAuth)delegate;
  }

  @Override 
  public io.vertx.ext.auth.oauth2.providers.GitLabAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for GitLab.com.
   * @param vertx 
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String clientId, java.lang.String clientSecret) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for GitLab.
   *
   * This method allows to specify custom GitLab domain.
   * @param vertx 
   * @param site root URL for the provider without trailing slashes, eg. https://gitlab.com
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String site, java.lang.String clientId, java.lang.String clientSecret) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), site, clientId, clientSecret));
    return ret;
  }

  /**
   * Create a OAuth2Auth provider for GitLab.
   * @param vertx 
   * @param site root URL for the provider without trailing slashes, eg. https://gitlab.com
   * @param clientId the client id given to you by GitLab
   * @param clientSecret the client secret given to you by GitLab
   * @param httpClientOptions custom http client options
   * @return 
   */
  public static io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava3.core.Vertx vertx, java.lang.String site, java.lang.String clientId, java.lang.String clientSecret, io.vertx.core.http.HttpClientOptions httpClientOptions) { 
    io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava3.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.providers.GitLabAuth.create(vertx.getDelegate(), site, clientId, clientSecret, httpClientOptions));
    return ret;
  }

  public static GitLabAuth newInstance(io.vertx.ext.auth.oauth2.providers.GitLabAuth arg) {
    return arg != null ? new GitLabAuth(arg) : null;
  }

}
