/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth.authorization;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;


@RxGen(io.vertx.ext.auth.authorization.Authorizations.class)
public class Authorizations implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Authorizations that = (Authorizations) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Authorizations> __TYPE_ARG = new TypeArg<>(    obj -> new Authorizations((io.vertx.ext.auth.authorization.Authorizations) obj),
    Authorizations::getDelegate
  );

  private final io.vertx.ext.auth.authorization.Authorizations delegate;
  
  public Authorizations(io.vertx.ext.auth.authorization.Authorizations delegate) {
    this.delegate = delegate;
  }

  public Authorizations(Object delegate) {
    this.delegate = (io.vertx.ext.auth.authorization.Authorizations)delegate;
  }

  @Override 
  public io.vertx.ext.auth.authorization.Authorizations getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava3.ext.auth.authorization.Authorization> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava3.ext.auth.authorization.Authorization>(o1 -> io.vertx.rxjava3.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)o1), o1 -> o1.getDelegate());

  public io.vertx.rxjava3.ext.auth.authorization.Authorizations add(java.lang.String providerId, java.util.Set<io.vertx.rxjava3.ext.auth.authorization.Authorization> authorizations) { 
    delegate.add(providerId, authorizations.stream().map(elt -> elt.getDelegate()).collect(Collectors.toSet()));
    return this;
  }

  public io.vertx.rxjava3.ext.auth.authorization.Authorizations add(java.lang.String providerId, io.vertx.rxjava3.ext.auth.authorization.Authorization authorization) { 
    delegate.add(providerId, authorization.getDelegate());
    return this;
  }

  public io.vertx.rxjava3.ext.auth.authorization.Authorizations clear(java.lang.String providerId) { 
    delegate.clear(providerId);
    return this;
  }

  public io.vertx.rxjava3.ext.auth.authorization.Authorizations clear() { 
    delegate.clear();
    return this;
  }

  public java.util.Set<io.vertx.rxjava3.ext.auth.authorization.Authorization> get(java.lang.String providerId) { 
    java.util.Set<io.vertx.rxjava3.ext.auth.authorization.Authorization> ret = delegate.get(providerId).stream().map(elt -> io.vertx.rxjava3.ext.auth.authorization.Authorization.newInstance((io.vertx.ext.auth.authorization.Authorization)elt)).collect(Collectors.toSet());
    return ret;
  }

  public java.util.Set<java.lang.String> getProviderIds() { 
    java.util.Set<java.lang.String> ret = delegate.getProviderIds();
    return ret;
  }

  public static Authorizations newInstance(io.vertx.ext.auth.authorization.Authorizations arg) {
    return arg != null ? new Authorizations(arg) : null;
  }

}
