/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.core.streams;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * Represents a stream of data that can be written to.
 * <p>
 * Any class that implements this interface can be used by a {@link io.vertx.rxjava3.core.streams.Pipe} to pipe data from a <code>ReadStream</code>
 * to it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.WriteStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.streams.WriteStream.class)
public interface WriteStream<T> extends RxDelegate, io.vertx.rxjava3.core.streams.StreamBase {

  @Override 
  io.vertx.core.streams.WriteStream getDelegate();

  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(T data);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(T data);

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end();

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd();

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end(T data);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd(T data);

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * {@link io.vertx.rxjava3.core.streams.Pipe} to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava3.core.net.NetSocket}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava3.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull();

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava3.core.streams.Pipe} for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> drainHandler(io.vertx.core.Handler<java.lang.Void> handler);

  WriteStreamObserver<T> toObserver();

  WriteStreamSubscriber<T> toSubscriber();

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg) {
    return arg != null ? new WriteStreamImpl<T>(arg) : null;
  }

  public static <T> WriteStream<T> newInstance(io.vertx.core.streams.WriteStream arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new WriteStreamImpl<T>(arg, __typeArg_T) : null;
  }

}

class WriteStreamImpl<T> implements WriteStream<T> {
  private final io.vertx.core.streams.WriteStream<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public WriteStreamImpl(io.vertx.core.streams.WriteStream delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public WriteStreamImpl(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.streams.WriteStream)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  @Override 
  public io.vertx.core.streams.WriteStream getDelegate() {
    return delegate;
  }

  private WriteStreamObserver<T> observer;
  private WriteStreamSubscriber<T> subscriber;

  public synchronized WriteStreamObserver<T> toObserver() {
    if (observer == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      observer = RxHelper.toObserver(getDelegate(), conv);
    }
    return observer;
  }

  public synchronized WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      Function<T, T> conv = (Function<T, T>) __typeArg_0.unwrap;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }


  /**
   * Set an exception handler on the write stream.
   * @param handler the exception handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> exceptionHandler(io.vertx.core.Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable write(T data) { 
    io.reactivex.rxjava3.core.Completable ret = rxWrite(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxWrite(T data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.write(__typeArg_0.<T>unwrap(data), handler);
    });
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end() { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava3.core.streams.WriteStream#end} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd() { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(handler);
    });
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable end(T data) { 
    io.reactivex.rxjava3.core.Completable ret = rxEnd(data);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxEnd(T data) { 
    return AsyncResultCompletable.toCompletable( handler -> {
      delegate.end(__typeArg_0.<T>unwrap(data), handler);
    });
  }

  /**
   * Set the maximum size of the write queue to <code>maxSize</code>. You will still be able to write to the stream even
   * if there is more than <code>maxSize</code> items in the write queue. This is used as an indicator by classes such as
   * {@link io.vertx.rxjava3.core.streams.Pipe} to provide flow control.
   * <p/>
   * The value is defined by the implementation of the stream, e.g in bytes for a
   * {@link io.vertx.rxjava3.core.net.NetSocket}, etc...
   * @param maxSize the max size of the write stream
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava3.core.streams.WriteStream#setWriteQueueMaxSize}
   * @return <code>true</code> if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Set a drain handler on the stream. If the write queue is full, then the handler will be called when the write
   * queue is ready to accept buffers again. See {@link io.vertx.rxjava3.core.streams.Pipe} for an example of this being used.
   *
   * <p> The stream implementation defines when the drain handler, for example it could be when the queue size has been
   * reduced to <code>maxSize / 2</code>.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava3.core.streams.WriteStream<T> drainHandler(io.vertx.core.Handler<java.lang.Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

}
