/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.web;

import io.reactivex.rxjava3.core.Completable;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.impl.AsyncResultCompletable;

@RxGen(value=io.vertx.ext.web.UserContext.class)
public class UserContext
implements RxDelegate {
    public static final TypeArg<UserContext> __TYPE_ARG = new TypeArg(obj -> new UserContext((io.vertx.ext.web.UserContext)obj), UserContext::getDelegate);
    private final io.vertx.ext.web.UserContext delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserContext that = (UserContext)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public UserContext(io.vertx.ext.web.UserContext delegate) {
        this.delegate = delegate;
    }

    public UserContext(Object delegate) {
        this.delegate = (io.vertx.ext.web.UserContext)delegate;
    }

    public io.vertx.ext.web.UserContext getDelegate() {
        return this.delegate;
    }

    public User get() {
        User ret = User.newInstance(this.delegate.get());
        return ret;
    }

    public boolean authenticated() {
        boolean ret = this.delegate.authenticated();
        return ret;
    }

    public UserContext loginHint(String loginHint) {
        this.delegate.loginHint(loginHint);
        return this;
    }

    public Completable impersonate() {
        Completable ret = this.rxImpersonate();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxImpersonate() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.impersonate(callback));
    }

    public Completable impersonate(String redirectUri) {
        Completable ret = this.rxImpersonate(redirectUri);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxImpersonate(String redirectUri) {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.impersonate(redirectUri, callback));
    }

    public Completable restore() {
        Completable ret = this.rxRestore();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRestore() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.restore(callback));
    }

    public Completable restore(String redirectUri) {
        Completable ret = this.rxRestore(redirectUri);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRestore(String redirectUri) {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.restore(redirectUri, callback));
    }

    public Completable logout(String redirectUri) {
        Completable ret = this.rxLogout(redirectUri);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxLogout(String redirectUri) {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.logout(redirectUri, callback));
    }

    public Completable logout() {
        Completable ret = this.rxLogout();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxLogout() {
        return AsyncResultCompletable.toCompletable(callback -> this.delegate.logout(callback));
    }

    public void clear() {
        this.delegate.clear();
    }

    public static UserContext newInstance(io.vertx.ext.web.UserContext arg) {
        return arg != null ? new UserContext(arg) : null;
    }
}

