/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.datagram;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.datagram.DatagramPacket;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.core.streams.Pipe;
import io.vertx.rxjava3.core.streams.ReadStream;
import io.vertx.rxjava3.core.streams.WriteStream;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.core.datagram.DatagramSocket.class)
public class DatagramSocket
implements RxDelegate,
ReadStream<DatagramPacket>,
Measured {
    public static final TypeArg<DatagramSocket> __TYPE_ARG = new TypeArg(obj -> new DatagramSocket((io.vertx.core.datagram.DatagramSocket)obj), DatagramSocket::getDelegate);
    private final io.vertx.core.datagram.DatagramSocket delegate;
    private Observable<DatagramPacket> observable;
    private Flowable<DatagramPacket> flowable;
    private static final TypeArg<DatagramPacket> TYPE_ARG_0 = new TypeArg(o1 -> DatagramPacket.newInstance((io.vertx.core.datagram.DatagramPacket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<io.vertx.rxjava3.core.buffer.Buffer> TYPE_ARG_1 = new TypeArg(o1 -> io.vertx.rxjava3.core.buffer.Buffer.newInstance((Buffer)o1), o1 -> o1.getDelegate());
    private SocketAddress cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatagramSocket that = (DatagramSocket)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DatagramSocket(io.vertx.core.datagram.DatagramSocket delegate) {
        this.delegate = delegate;
    }

    public DatagramSocket(Object delegate) {
        this.delegate = (io.vertx.core.datagram.DatagramSocket)delegate;
    }

    public io.vertx.core.datagram.DatagramSocket getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<DatagramPacket> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.observable = ObservableHelper.toObservable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<DatagramPacket> toFlowable() {
        if (this.flowable == null) {
            Function<io.vertx.core.datagram.DatagramPacket, DatagramPacket> conv = DatagramPacket::newInstance;
            this.flowable = FlowableHelper.toFlowable((io.vertx.core.streams.ReadStream)this.delegate, conv);
        }
        return this.flowable;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    @Override
    public Pipe<DatagramPacket> pipe() {
        Pipe<DatagramPacket> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public Completable pipeTo(WriteStream<DatagramPacket> dst) {
        Completable ret = this.rxPipeTo(dst);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<DatagramPacket> dst) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.pipeTo(dst.getDelegate(), handler));
    }

    public Completable send(io.vertx.rxjava3.core.buffer.Buffer packet, int port, String host) {
        Completable ret = this.rxSend(packet, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(io.vertx.rxjava3.core.buffer.Buffer packet, int port, String host) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(packet.getDelegate(), port, host, handler));
    }

    public WriteStream<io.vertx.rxjava3.core.buffer.Buffer> sender(int port, String host) {
        WriteStream<io.vertx.rxjava3.core.buffer.Buffer> ret = WriteStream.newInstance(this.delegate.sender(port, host), TYPE_ARG_1);
        return ret;
    }

    public Completable send(String str, int port, String host) {
        Completable ret = this.rxSend(str, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String str, int port, String host) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(str, port, host, handler));
    }

    public Completable send(String str, String enc, int port, String host) {
        Completable ret = this.rxSend(str, enc, port, host);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxSend(String str, String enc, int port, String host) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.send(str, enc, port, host, handler));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = SocketAddress.newInstance(this.delegate.localAddress());
        return ret;
    }

    public Completable listenMulticastGroup(String multicastAddress) {
        Completable ret = this.rxListenMulticastGroup(multicastAddress);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.listenMulticastGroup(multicastAddress, handler));
    }

    public Completable listenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Completable ret = this.rxListenMulticastGroup(multicastAddress, networkInterface, source);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxListenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.listenMulticastGroup(multicastAddress, networkInterface, source, handler));
    }

    public Completable unlistenMulticastGroup(String multicastAddress) {
        Completable ret = this.rxUnlistenMulticastGroup(multicastAddress);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.unlistenMulticastGroup(multicastAddress, handler));
    }

    public Completable unlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        Completable ret = this.rxUnlistenMulticastGroup(multicastAddress, networkInterface, source);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxUnlistenMulticastGroup(String multicastAddress, String networkInterface, String source) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.unlistenMulticastGroup(multicastAddress, networkInterface, source, handler));
    }

    public Completable blockMulticastGroup(String multicastAddress, String sourceToBlock) {
        Completable ret = this.rxBlockMulticastGroup(multicastAddress, sourceToBlock);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.blockMulticastGroup(multicastAddress, sourceToBlock, handler));
    }

    public Completable blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        Completable ret = this.rxBlockMulticastGroup(multicastAddress, networkInterface, sourceToBlock);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxBlockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.blockMulticastGroup(multicastAddress, networkInterface, sourceToBlock, handler));
    }

    public Single<DatagramSocket> listen(int port, String host) {
        Single ret = this.rxListen(port, host);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<DatagramSocket> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.listen(port, host, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> DatagramSocket.newInstance(event)))));
    }

    @Deprecated
    public DatagramSocket pause() {
        this.delegate.pause();
        return this;
    }

    @Deprecated
    public DatagramSocket resume() {
        this.delegate.resume();
        return this;
    }

    @Deprecated
    public DatagramSocket fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @Deprecated
    public DatagramSocket endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public DatagramSocket handler(Handler<DatagramPacket> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> DatagramPacket.newInstance(event)));
        return this;
    }

    @Override
    public DatagramSocket exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public static DatagramSocket newInstance(io.vertx.core.datagram.DatagramSocket arg) {
        return arg != null ? new DatagramSocket(arg) : null;
    }
}

