/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.servicediscovery.spi;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The publisher is used by the importer to publish or unpublish records.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.spi.ServicePublisher original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.spi.ServicePublisher.class)
public class ServicePublisher implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServicePublisher that = (ServicePublisher) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ServicePublisher> __TYPE_ARG = new TypeArg<>(    obj -> new ServicePublisher((io.vertx.servicediscovery.spi.ServicePublisher) obj),
    ServicePublisher::getDelegate
  );

  private final io.vertx.servicediscovery.spi.ServicePublisher delegate;
  
  public ServicePublisher(io.vertx.servicediscovery.spi.ServicePublisher delegate) {
    this.delegate = delegate;
  }

  public ServicePublisher(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.spi.ServicePublisher)delegate;
  }

  @Override 
  public io.vertx.servicediscovery.spi.ServicePublisher getDelegate() {
    return delegate;
  }

  /**
   * Publishes a record.
   * @param record the record
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> publish(io.vertx.servicediscovery.Record record) { 
    io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> ret = rxPublish(record);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Publishes a record.
   * @param record the record
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> rxPublish(io.vertx.servicediscovery.Record record) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.publish(record, resultHandler);
    });
  }

  /**
   * Un-publishes a record.
   * @param id the registration id
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable unpublish(java.lang.String id) { 
    io.reactivex.rxjava3.core.Completable ret = rxUnpublish(id);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  /**
   * Un-publishes a record.
   * @param id the registration id
   * @return 
   */
  public io.reactivex.rxjava3.core.Completable rxUnpublish(java.lang.String id) { 
    return AsyncResultCompletable.toCompletable( resultHandler -> {
      delegate.unpublish(id, resultHandler);
    });
  }

  /**
   * Updates an existing record.
   * @param record the record
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> update(io.vertx.servicediscovery.Record record) { 
    io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> ret = rxUpdate(record);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.SingleHelper.nullObserver());
    return ret;
  }

  /**
   * Updates an existing record.
   * @param record the record
   * @return 
   */
  public io.reactivex.rxjava3.core.Single<io.vertx.servicediscovery.Record> rxUpdate(io.vertx.servicediscovery.Record record) { 
    return AsyncResultSingle.toSingle( resultHandler -> {
      delegate.update(record, resultHandler);
    });
  }

  public static ServicePublisher newInstance(io.vertx.servicediscovery.spi.ServicePublisher arg) {
    return arg != null ? new ServicePublisher(arg) : null;
  }

}
