/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web.validation.builder;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * In this interface you can find all available {@link io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory}, {@link io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory} & {@link io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.validation.builder.Parsers original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.validation.builder.Parsers.class)
public class Parsers implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Parsers that = (Parsers) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Parsers> __TYPE_ARG = new TypeArg<>(    obj -> new Parsers((io.vertx.ext.web.validation.builder.Parsers) obj),
    Parsers::getDelegate
  );

  private final io.vertx.ext.web.validation.builder.Parsers delegate;
  
  public Parsers(io.vertx.ext.web.validation.builder.Parsers delegate) {
    this.delegate = delegate;
  }

  public Parsers(Object delegate) {
    this.delegate = (io.vertx.ext.web.validation.builder.Parsers)delegate;
  }

  @Override 
  public io.vertx.ext.web.validation.builder.Parsers getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory commaSeparatedArrayParser() { 
    io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ArrayParserFactory.newInstance((io.vertx.ext.web.validation.builder.ArrayParserFactory)io.vertx.ext.web.validation.builder.Parsers.commaSeparatedArrayParser());
    return ret;
  }

  public static io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory commaSeparatedObjectParser() { 
    io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory ret = io.vertx.rxjava3.ext.web.validation.builder.ObjectParserFactory.newInstance((io.vertx.ext.web.validation.builder.ObjectParserFactory)io.vertx.ext.web.validation.builder.Parsers.commaSeparatedObjectParser());
    return ret;
  }

  public static io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory commaSeparatedTupleParser() { 
    io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory ret = io.vertx.rxjava3.ext.web.validation.builder.TupleParserFactory.newInstance((io.vertx.ext.web.validation.builder.TupleParserFactory)io.vertx.ext.web.validation.builder.Parsers.commaSeparatedTupleParser());
    return ret;
  }

  public static Parsers newInstance(io.vertx.ext.web.validation.builder.Parsers arg) {
    return arg != null ? new Parsers(arg) : null;
  }

}
