/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.web;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A web user is extended user coupled to the context and is used to perform verifications
 * and actions on behalf of the user. Actions can be:
 *
 * <ul>
 *   <li>{@link io.vertx.rxjava3.ext.web.UserContext#impersonate} - Require a re-authentication to switch user identities</li>
 *   <li>{@link io.vertx.rxjava3.ext.web.UserContext#restore} - De-escalate a previous impersonate call</li>
 *   <li>{@link io.vertx.rxjava3.ext.web.UserContext#logout} - Logout the user from this application and redirect to a uri</li>
 *   <li>{@link io.vertx.rxjava3.ext.web.UserContext#clear} - Same as logout, without requirind a redirect</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.UserContext original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.UserContext.class)
public class UserContext implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UserContext that = (UserContext) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<UserContext> __TYPE_ARG = new TypeArg<>(    obj -> new UserContext((io.vertx.ext.web.UserContext) obj),
    UserContext::getDelegate
  );

  private final io.vertx.ext.web.UserContext delegate;
  
  public UserContext(io.vertx.ext.web.UserContext delegate) {
    this.delegate = delegate;
  }

  public UserContext(Object delegate) {
    this.delegate = (io.vertx.ext.web.UserContext)delegate;
  }

  @Override 
  public io.vertx.ext.web.UserContext getDelegate() {
    return delegate;
  }

  /**
   * Get the authenticated user (if any). This will usually be injected by an auth handler if authentication if successful.
   * @return the user, or null if the current user is not authenticated.
   */
  public io.vertx.rxjava3.ext.auth.User get() { 
    io.vertx.rxjava3.ext.auth.User ret = io.vertx.rxjava3.ext.auth.User.newInstance((io.vertx.ext.auth.User)delegate.get());
    return ret;
  }

  public boolean authenticated() { 
    boolean ret = delegate.authenticated();
    return ret;
  }

  /**
   * When performing a web identity operation, hint if possible to the identity provider to use the given login.
   * @param loginHint the desired login name, for example: <code>admin</code>.
   * @return fluent self
   */
  public io.vertx.rxjava3.ext.web.UserContext loginHint(java.lang.String loginHint) { 
    delegate.loginHint(loginHint);
    return this;
  }

  public io.reactivex.rxjava3.core.Completable impersonate() { 
    io.reactivex.rxjava3.core.Completable ret = rxImpersonate();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxImpersonate() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.impersonate(callback);
    });
  }

  public io.reactivex.rxjava3.core.Completable impersonate(java.lang.String redirectUri) { 
    io.reactivex.rxjava3.core.Completable ret = rxImpersonate(redirectUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxImpersonate(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.impersonate(redirectUri, callback);
    });
  }

  public io.reactivex.rxjava3.core.Completable restore() { 
    io.reactivex.rxjava3.core.Completable ret = rxRestore();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxRestore() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.restore(callback);
    });
  }

  public io.reactivex.rxjava3.core.Completable restore(java.lang.String redirectUri) { 
    io.reactivex.rxjava3.core.Completable ret = rxRestore(redirectUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxRestore(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.restore(redirectUri, callback);
    });
  }

  public io.reactivex.rxjava3.core.Completable logout(java.lang.String redirectUri) { 
    io.reactivex.rxjava3.core.Completable ret = rxLogout(redirectUri);
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxLogout(java.lang.String redirectUri) { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.logout(redirectUri, callback);
    });
  }

  public io.reactivex.rxjava3.core.Completable logout() { 
    io.reactivex.rxjava3.core.Completable ret = rxLogout();
    ret = ret.cache();
    ret.subscribe(io.vertx.rxjava3.CompletableHelper.nullObserver());
    return ret;
  }

  public io.reactivex.rxjava3.core.Completable rxLogout() { 
    return AsyncResultCompletable.toCompletable( callback -> {
      delegate.logout(callback);
    });
  }

  /**
   * Clear can be called from any route handler which needs to terminate a login session. Invoking logout will remove
   * the {@link io.vertx.rxjava3.ext.auth.User} and clear the {@link io.vertx.rxjava3.ext.web.Session} (if any) in the current context. Unlike
   * {@link io.vertx.rxjava3.ext.web.UserContext#logout} no redirect will be performed.
   */
  public void clear() { 
    delegate.clear();
  }

  public static UserContext newInstance(io.vertx.ext.web.UserContext arg) {
    return arg != null ? new UserContext(arg) : null;
  }

}
