/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava3.ext.auth;

import io.vertx.rxjava3.RxHelper;
import io.vertx.rxjava3.ObservableHelper;
import io.vertx.rxjava3.FlowableHelper;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Hashing Strategy manager.
 *
 * This class will load system provided hashing strategies and algorithms.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.HashingStrategy original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.HashingStrategy.class)
@Deprecated()
public class HashingStrategy implements RxDelegate {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HashingStrategy that = (HashingStrategy) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<HashingStrategy> __TYPE_ARG = new TypeArg<>(    obj -> new HashingStrategy((io.vertx.ext.auth.HashingStrategy) obj),
    HashingStrategy::getDelegate
  );

  private final io.vertx.ext.auth.HashingStrategy delegate;
  
  public HashingStrategy(io.vertx.ext.auth.HashingStrategy delegate) {
    this.delegate = delegate;
  }

  public HashingStrategy(Object delegate) {
    this.delegate = (io.vertx.ext.auth.HashingStrategy)delegate;
  }

  @Override 
  public io.vertx.ext.auth.HashingStrategy getDelegate() {
    return delegate;
  }

  /**
   * Factory method to load the algorithms from the system
   * @return a Hashing Strategy capable of hashing using the available algorithms
   */
  @Deprecated()
  public static io.vertx.rxjava3.ext.auth.HashingStrategy load() { 
    io.vertx.rxjava3.ext.auth.HashingStrategy ret = io.vertx.rxjava3.ext.auth.HashingStrategy.newInstance((io.vertx.ext.auth.HashingStrategy)io.vertx.ext.auth.HashingStrategy.load());
    return ret;
  }

  /**
   * Hashes a password.
   * @param id the algorithm id
   * @param params the algorithm specific parameters
   * @param salt the given salt
   * @param password the given password
   * @return the hashed string
   */
  @Deprecated()
  public java.lang.String hash(java.lang.String id, java.util.Map<java.lang.String,java.lang.String> params, java.lang.String salt, java.lang.String password) { 
    java.lang.String ret = delegate.hash(id, params, salt, password);
    return ret;
  }

  /**
   * Time constant password check. Regardless of the check, this algorithm executes the same number of
   * checks regardless of the correctly number of characters
   * @param hash the hash to verify
   * @param password the password to test against
   * @return boolean
   */
  @Deprecated()
  public boolean verify(java.lang.String hash, java.lang.String password) { 
    boolean ret = delegate.verify(hash, password);
    return ret;
  }

  /**
   * Get an algorithm interface by its Id
   * @param id the algorithm id
   * @return the algorithm
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.auth.HashingAlgorithm get(java.lang.String id) { 
    io.vertx.rxjava3.ext.auth.HashingAlgorithm ret = io.vertx.rxjava3.ext.auth.HashingAlgorithm.newInstance((io.vertx.ext.auth.HashingAlgorithm)delegate.get(id));
    return ret;
  }

  /**
   * Put or replace an algorithm into the list of system loaded algorithms.
   * @param id the algorithm id
   * @param algorithm the implementation
   * @return self
   */
  @Deprecated()
  public io.vertx.rxjava3.ext.auth.HashingStrategy put(java.lang.String id, io.vertx.rxjava3.ext.auth.HashingAlgorithm algorithm) { 
    delegate.put(id, algorithm.getDelegate());
    return this;
  }

  public static HashingStrategy newInstance(io.vertx.ext.auth.HashingStrategy arg) {
    return arg != null ? new HashingStrategy(arg) : null;
  }

}
