/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.dns;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rxjava3.Helper;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.MaybeHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.dns.MxRecord;
import io.vertx.rxjava3.core.dns.SrvRecord;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultMaybe;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient
implements RxDelegate {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public Maybe<String> lookup(String name) {
        Maybe ret = this.rxLookup(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup(String name) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lookup(name, handler));
    }

    public Maybe<String> lookup4(String name) {
        Maybe ret = this.rxLookup4(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup4(String name) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lookup4(name, handler));
    }

    public Maybe<String> lookup6(String name) {
        Maybe ret = this.rxLookup6(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxLookup6(String name) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.lookup6(name, handler));
    }

    public Single<List<String>> resolveA(String name) {
        Single ret = this.rxResolveA(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveA(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveA(name, handler));
    }

    public Single<List<String>> resolveAAAA(String name) {
        Single ret = this.rxResolveAAAA(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveAAAA(name, handler));
    }

    public Single<List<String>> resolveCNAME(String name) {
        Single ret = this.rxResolveCNAME(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveCNAME(name, handler));
    }

    public Single<List<MxRecord>> resolveMX(String name) {
        Single ret = this.rxResolveMX(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveMX(name, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> event.stream().map(elt -> MxRecord.newInstance(elt)).collect(Collectors.toList())))));
    }

    public Single<List<String>> resolveTXT(String name) {
        Single ret = this.rxResolveTXT(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveTXT(name, handler));
    }

    public Maybe<String> resolvePTR(String name) {
        Maybe ret = this.rxResolvePTR(name);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxResolvePTR(String name) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.resolvePTR(name, handler));
    }

    public Single<List<String>> resolveNS(String name) {
        Single ret = this.rxResolveNS(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<String>> rxResolveNS(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveNS(name, handler));
    }

    public Single<List<SrvRecord>> resolveSRV(String name) {
        Single ret = this.rxResolveSRV(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.resolveSRV(name, Helper.convertHandler((Handler)handler, ar -> ar.map(event -> event.stream().map(elt -> SrvRecord.newInstance(elt)).collect(Collectors.toList())))));
    }

    public Maybe<String> reverseLookup(String ipaddress) {
        Maybe ret = this.rxReverseLookup(ipaddress);
        ret = ret.cache();
        ret.subscribe(MaybeHelper.nullObserver());
        return ret;
    }

    public Maybe<String> rxReverseLookup(String ipaddress) {
        return AsyncResultMaybe.toMaybe(handler -> this.delegate.reverseLookup(ipaddress, handler));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

