/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.auth.webauthn;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.AuthenticationProvider;
import io.vertx.ext.auth.webauthn.Authenticator;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.auth.webauthn.MetaDataService;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import java.util.List;
import java.util.function.Function;

@RxGen(value=io.vertx.ext.auth.webauthn.WebAuthn.class)
public class WebAuthn
extends io.vertx.rxjava3.ext.auth.authentication.AuthenticationProvider
implements RxDelegate {
    public static final TypeArg<WebAuthn> __TYPE_ARG = new TypeArg(obj -> new WebAuthn((io.vertx.ext.auth.webauthn.WebAuthn)obj), WebAuthn::getDelegate);
    private final io.vertx.ext.auth.webauthn.WebAuthn delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebAuthn that = (WebAuthn)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebAuthn(io.vertx.ext.auth.webauthn.WebAuthn delegate) {
        super((AuthenticationProvider)delegate);
        this.delegate = delegate;
    }

    public WebAuthn(Object delegate) {
        super((AuthenticationProvider)((io.vertx.ext.auth.webauthn.WebAuthn)delegate));
        this.delegate = (io.vertx.ext.auth.webauthn.WebAuthn)delegate;
    }

    public io.vertx.ext.auth.webauthn.WebAuthn getDelegate() {
        return this.delegate;
    }

    public static WebAuthn create(io.vertx.rxjava3.core.Vertx vertx) {
        WebAuthn ret = WebAuthn.newInstance(io.vertx.ext.auth.webauthn.WebAuthn.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static WebAuthn create(io.vertx.rxjava3.core.Vertx vertx, WebAuthnOptions options) {
        WebAuthn ret = WebAuthn.newInstance(io.vertx.ext.auth.webauthn.WebAuthn.create((Vertx)vertx.getDelegate(), (WebAuthnOptions)options));
        return ret;
    }

    public Single<JsonObject> createCredentialsOptions(JsonObject user) {
        Single ret = this.rxCreateCredentialsOptions(user);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonObject> rxCreateCredentialsOptions(JsonObject user) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.createCredentialsOptions(user, handler));
    }

    public Single<JsonObject> getCredentialsOptions(String name) {
        Single ret = this.rxGetCredentialsOptions(name);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<JsonObject> rxGetCredentialsOptions(String name) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.getCredentialsOptions(name, handler));
    }

    public WebAuthn authenticatorFetcher(final Function<Authenticator, Single<List<Authenticator>>> fetcher) {
        this.delegate.authenticatorFetcher((Function)new Function<Authenticator, Future<List<Authenticator>>>(){

            @Override
            public Future<List<Authenticator>> apply(Authenticator arg) {
                Single ret = (Single)fetcher.apply(arg);
                return SingleHelper.toFuture((Single)ret, obj -> obj);
            }
        });
        return this;
    }

    public WebAuthn authenticatorUpdater(final Function<Authenticator, Completable> updater) {
        this.delegate.authenticatorUpdater((Function)new Function<Authenticator, Future<Void>>(){

            @Override
            public Future<Void> apply(Authenticator arg) {
                Completable ret = (Completable)updater.apply(arg);
                return CompletableHelper.toFuture((Completable)ret);
            }
        });
        return this;
    }

    public MetaDataService metaDataService() {
        MetaDataService ret = MetaDataService.newInstance(this.delegate.metaDataService());
        return ret;
    }

    public static WebAuthn newInstance(io.vertx.ext.auth.webauthn.WebAuthn arg) {
        return arg != null ? new WebAuthn(arg) : null;
    }
}

