/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.http;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.Handler;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.SSLOptions;
import io.vertx.lang.rx.DelegatingHandler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.core.http.ClientWebSocket;
import io.vertx.rxjava3.core.http.WebSocket;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.http.WebSocketClient.class)
public class WebSocketClient
implements Measured {
    public static final TypeArg<WebSocketClient> __TYPE_ARG = new TypeArg(obj -> new WebSocketClient((io.vertx.core.http.WebSocketClient)obj), WebSocketClient::getDelegate);
    private final io.vertx.core.http.WebSocketClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketClient that = (WebSocketClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public WebSocketClient(io.vertx.core.http.WebSocketClient delegate) {
        this.delegate = delegate;
    }

    public WebSocketClient(Object delegate) {
        this.delegate = (io.vertx.core.http.WebSocketClient)delegate;
    }

    public io.vertx.core.http.WebSocketClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public ClientWebSocket webSocket() {
        ClientWebSocket ret = ClientWebSocket.newInstance(this.delegate.webSocket());
        return ret;
    }

    public Single<WebSocket> connect(int port, String host, String requestURI) {
        Single ret = this.rxConnect(port, host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(int port, String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect(port, host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> connect(String host, String requestURI) {
        Single ret = this.rxConnect(host, requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(String host, String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect(host, requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> connect(String requestURI) {
        Single ret = this.rxConnect(requestURI);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(String requestURI) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect(requestURI, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<WebSocket> connect(WebSocketConnectOptions options) {
        Single ret = this.rxConnect(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<WebSocket> rxConnect(WebSocketConnectOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.connect(options, (Handler)new DelegatingHandler(handler, ar -> ar.map(event -> WebSocket.newInstance(event)))));
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options) {
        Single ret = this.rxUpdateSSLOptions(options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, handler));
    }

    public Single<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        Single ret = this.rxUpdateSSLOptions(options, force);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(SSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.updateSSLOptions(options, force, handler));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public static WebSocketClient newInstance(io.vertx.core.http.WebSocketClient arg) {
        return arg != null ? new WebSocketClient(arg) : null;
    }
}

