/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.web;

import io.reactivex.rxjava3.core.Completable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.core.http.HttpServerRequest;
import io.vertx.rxjava3.core.http.HttpServerResponse;
import io.vertx.rxjava3.ext.auth.User;
import io.vertx.rxjava3.ext.web.FileUpload;
import io.vertx.rxjava3.ext.web.LanguageHeader;
import io.vertx.rxjava3.ext.web.ParsedHeaderValues;
import io.vertx.rxjava3.ext.web.RequestBody;
import io.vertx.rxjava3.ext.web.Route;
import io.vertx.rxjava3.ext.web.Session;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.ext.web.RoutingContext.class)
public class RoutingContext {
    public static final TypeArg<RoutingContext> __TYPE_ARG = new TypeArg(obj -> new RoutingContext((io.vertx.ext.web.RoutingContext)obj), RoutingContext::getDelegate);
    private final io.vertx.ext.web.RoutingContext delegate;
    private static final TypeArg<io.vertx.rxjava3.core.http.Cookie> TYPE_ARG_0 = new TypeArg(o1 -> io.vertx.rxjava3.core.http.Cookie.newInstance((Cookie)o1), o1 -> o1.getDelegate());
    private static final TypeArg<FileUpload> TYPE_ARG_1 = new TypeArg(o1 -> FileUpload.newInstance((io.vertx.ext.web.FileUpload)o1), o1 -> o1.getDelegate());
    private static final TypeArg<LanguageHeader> TYPE_ARG_2 = new TypeArg(o1 -> LanguageHeader.newInstance((io.vertx.ext.web.LanguageHeader)o1), o1 -> o1.getDelegate());
    private HttpServerRequest cached_0;
    private HttpServerResponse cached_1;
    private Vertx cached_2;
    private Throwable cached_3;
    private Integer cached_4;
    private ParsedHeaderValues cached_5;
    private List<LanguageHeader> cached_6;
    private LanguageHeader cached_7;
    private Boolean cached_8;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingContext that = (RoutingContext)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RoutingContext(io.vertx.ext.web.RoutingContext delegate) {
        this.delegate = delegate;
    }

    public RoutingContext(Object delegate) {
        this.delegate = (io.vertx.ext.web.RoutingContext)delegate;
    }

    public io.vertx.ext.web.RoutingContext getDelegate() {
        return this.delegate;
    }

    public HttpServerRequest request() {
        HttpServerRequest ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerRequest.newInstance(this.delegate.request());
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public void next() {
        this.delegate.next();
    }

    public void fail(int statusCode) {
        this.delegate.fail(statusCode);
    }

    public void fail(Throwable throwable) {
        this.delegate.fail(throwable);
    }

    public void fail(int statusCode, Throwable throwable) {
        this.delegate.fail(statusCode, throwable);
    }

    public RoutingContext put(String key, Object obj) {
        this.delegate.put(key, obj);
        return this;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public <T> T get(String key, T defaultValue) {
        Object ret = this.delegate.get(key, defaultValue);
        return (T)ret;
    }

    public <T> T remove(String key) {
        Object ret = this.delegate.remove(key);
        return (T)ret;
    }

    public Vertx vertx() {
        Vertx ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = Vertx.newInstance(this.delegate.vertx());
        return ret;
    }

    public String mountPoint() {
        String ret = this.delegate.mountPoint();
        return ret;
    }

    public Route currentRoute() {
        Route ret = Route.newInstance(this.delegate.currentRoute());
        return ret;
    }

    @Deprecated
    public String normalisedPath() {
        String ret = this.delegate.normalisedPath();
        return ret;
    }

    public String normalizedPath() {
        String ret = this.delegate.normalizedPath();
        return ret;
    }

    @Deprecated
    public io.vertx.rxjava3.core.http.Cookie getCookie(String name) {
        io.vertx.rxjava3.core.http.Cookie ret = io.vertx.rxjava3.core.http.Cookie.newInstance(this.delegate.getCookie(name));
        return ret;
    }

    @Deprecated
    public RoutingContext addCookie(io.vertx.rxjava3.core.http.Cookie cookie) {
        this.delegate.addCookie(cookie.getDelegate());
        return this;
    }

    @Deprecated
    public io.vertx.rxjava3.core.http.Cookie removeCookie(String name) {
        io.vertx.rxjava3.core.http.Cookie ret = io.vertx.rxjava3.core.http.Cookie.newInstance(this.delegate.removeCookie(name));
        return ret;
    }

    @Deprecated
    public io.vertx.rxjava3.core.http.Cookie removeCookie(String name, boolean invalidate) {
        io.vertx.rxjava3.core.http.Cookie ret = io.vertx.rxjava3.core.http.Cookie.newInstance(this.delegate.removeCookie(name, invalidate));
        return ret;
    }

    @Deprecated
    public int cookieCount() {
        int ret = this.delegate.cookieCount();
        return ret;
    }

    @Deprecated
    public Map<String, io.vertx.rxjava3.core.http.Cookie> cookieMap() {
        Map<String, io.vertx.rxjava3.core.http.Cookie> ret = this.delegate.cookieMap().entrySet().stream().collect(Collectors.toMap(_e -> (String)_e.getKey(), _e -> io.vertx.rxjava3.core.http.Cookie.newInstance((Cookie)_e.getValue())));
        return ret;
    }

    @Deprecated
    public String getBodyAsString() {
        String ret = this.delegate.getBodyAsString();
        return ret;
    }

    @Deprecated
    public String getBodyAsString(String encoding) {
        String ret = this.delegate.getBodyAsString(encoding);
        return ret;
    }

    @Deprecated
    public JsonObject getBodyAsJson(int maxAllowedLength) {
        JsonObject ret = this.delegate.getBodyAsJson(maxAllowedLength);
        return ret;
    }

    @Deprecated
    public JsonArray getBodyAsJsonArray(int maxAllowedLength) {
        JsonArray ret = this.delegate.getBodyAsJsonArray(maxAllowedLength);
        return ret;
    }

    @Deprecated
    public JsonObject getBodyAsJson() {
        JsonObject ret = this.delegate.getBodyAsJson();
        return ret;
    }

    @Deprecated
    public JsonArray getBodyAsJsonArray() {
        JsonArray ret = this.delegate.getBodyAsJsonArray();
        return ret;
    }

    @Deprecated
    public Buffer getBody() {
        Buffer ret = Buffer.newInstance(this.delegate.getBody());
        return ret;
    }

    public RequestBody body() {
        RequestBody ret = RequestBody.newInstance(this.delegate.body());
        return ret;
    }

    public List<FileUpload> fileUploads() {
        List<FileUpload> ret = this.delegate.fileUploads().stream().map(elt -> FileUpload.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public Session session() {
        Session ret = Session.newInstance(this.delegate.session());
        return ret;
    }

    public boolean isSessionAccessed() {
        boolean ret = this.delegate.isSessionAccessed();
        return ret;
    }

    public User user() {
        User ret = User.newInstance(this.delegate.user());
        return ret;
    }

    public Throwable failure() {
        Throwable ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.failure();
        return ret;
    }

    public int statusCode() {
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        int ret = this.delegate.statusCode();
        this.cached_4 = ret;
        return ret;
    }

    public String getAcceptableContentType() {
        String ret = this.delegate.getAcceptableContentType();
        return ret;
    }

    public ParsedHeaderValues parsedHeaders() {
        ParsedHeaderValues ret;
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        this.cached_5 = ret = ParsedHeaderValues.newInstance(this.delegate.parsedHeaders());
        return ret;
    }

    public int addHeadersEndHandler(Handler<Void> handler) {
        int ret = this.delegate.addHeadersEndHandler(handler);
        return ret;
    }

    public boolean removeHeadersEndHandler(int handlerID) {
        boolean ret = this.delegate.removeHeadersEndHandler(handlerID);
        return ret;
    }

    public int addBodyEndHandler(Handler<Void> handler) {
        int ret = this.delegate.addBodyEndHandler(handler);
        return ret;
    }

    public boolean removeBodyEndHandler(int handlerID) {
        boolean ret = this.delegate.removeBodyEndHandler(handlerID);
        return ret;
    }

    public int addEndHandler(Handler<AsyncResult<Void>> handler) {
        int ret = this.delegate.addEndHandler(handler);
        return ret;
    }

    public boolean removeEndHandler(int handlerID) {
        boolean ret = this.delegate.removeEndHandler(handlerID);
        return ret;
    }

    public boolean failed() {
        boolean ret = this.delegate.failed();
        return ret;
    }

    @Deprecated
    public void setBody(Buffer body) {
        this.delegate.setBody(body.getDelegate());
    }

    @Deprecated
    public void setSession(Session session) {
        this.delegate.setSession(session.getDelegate());
    }

    public void setUser(User user) {
        this.delegate.setUser(user.getDelegate());
    }

    public void clearUser() {
        this.delegate.clearUser();
    }

    public void setAcceptableContentType(String contentType) {
        this.delegate.setAcceptableContentType(contentType);
    }

    public void reroute(String path) {
        this.delegate.reroute(path);
    }

    public void reroute(HttpMethod method, String path) {
        this.delegate.reroute(method, path);
    }

    public List<LanguageHeader> acceptableLanguages() {
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        List<LanguageHeader> ret = this.delegate.acceptableLanguages().stream().map(elt -> LanguageHeader.newInstance(elt)).collect(Collectors.toList());
        this.cached_6 = ret;
        return ret;
    }

    public LanguageHeader preferredLanguage() {
        LanguageHeader ret;
        if (this.cached_7 != null) {
            return this.cached_7;
        }
        this.cached_7 = ret = LanguageHeader.newInstance(this.delegate.preferredLanguage());
        return ret;
    }

    public Map<String, String> pathParams() {
        Map ret = this.delegate.pathParams();
        return ret;
    }

    public String pathParam(String name) {
        String ret = this.delegate.pathParam(name);
        return ret;
    }

    public MultiMap queryParams() {
        MultiMap ret = MultiMap.newInstance(this.delegate.queryParams());
        return ret;
    }

    public List<String> queryParam(String name) {
        List ret = this.delegate.queryParam(name);
        return ret;
    }

    public RoutingContext attachment(String filename) {
        this.delegate.attachment(filename);
        return this;
    }

    public Completable redirect(String url) {
        Completable ret = this.rxRedirect(url);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxRedirect(String url) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.redirect(url, handler));
    }

    public Completable json(Object json) {
        Completable ret = this.rxJson(json);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxJson(Object json) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.json(json, handler));
    }

    public boolean is(String type) {
        if (this.cached_8 != null) {
            return this.cached_8;
        }
        boolean ret = this.delegate.is(type);
        this.cached_8 = ret;
        return ret;
    }

    public boolean isFresh() {
        boolean ret = this.delegate.isFresh();
        return ret;
    }

    public RoutingContext etag(String etag) {
        this.delegate.etag(etag);
        return this;
    }

    public RoutingContext lastModified(String instant) {
        this.delegate.lastModified(instant);
        return this;
    }

    public Completable end(String chunk) {
        Completable ret = this.rxEnd(chunk);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd(String chunk) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(chunk, handler));
    }

    public Completable end(Buffer buffer) {
        Completable ret = this.rxEnd(buffer);
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd(Buffer buffer) {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(buffer.getDelegate(), handler));
    }

    public Completable end() {
        Completable ret = this.rxEnd();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.end(handler));
    }

    public Map<String, Object> data() {
        Map ret = this.delegate.data();
        return ret;
    }

    public MultiMap queryParams(Charset encoding) {
        MultiMap ret = MultiMap.newInstance(this.delegate.queryParams(encoding));
        return ret;
    }

    public RoutingContext lastModified(Instant instant) {
        this.delegate.lastModified(instant);
        return this;
    }

    public static RoutingContext newInstance(io.vertx.ext.web.RoutingContext arg) {
        return arg != null ? new RoutingContext(arg) : null;
    }
}

