/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.ext.web.openapi;

import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.openapi.OpenAPILoaderOptions;
import io.vertx.ext.web.openapi.RouterBuilderOptions;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.ext.web.Router;
import io.vertx.rxjava3.ext.web.RoutingContext;
import io.vertx.rxjava3.ext.web.handler.AuthenticationHandler;
import io.vertx.rxjava3.ext.web.handler.BodyHandler;
import io.vertx.rxjava3.ext.web.openapi.OpenAPIHolder;
import io.vertx.rxjava3.ext.web.openapi.Operation;
import io.vertx.rxjava3.ext.web.openapi.SecurityScheme;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.json.schema.SchemaParser;
import io.vertx.rxjava3.json.schema.SchemaRouter;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.ext.web.openapi.RouterBuilder.class)
public class RouterBuilder {
    public static final TypeArg<RouterBuilder> __TYPE_ARG = new TypeArg(obj -> new RouterBuilder((io.vertx.ext.web.openapi.RouterBuilder)obj), RouterBuilder::getDelegate);
    private final io.vertx.ext.web.openapi.RouterBuilder delegate;
    private static final TypeArg<Operation> TYPE_ARG_0 = new TypeArg(o1 -> Operation.newInstance((io.vertx.ext.web.openapi.Operation)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouterBuilder that = (RouterBuilder)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RouterBuilder(io.vertx.ext.web.openapi.RouterBuilder delegate) {
        this.delegate = delegate;
    }

    public RouterBuilder(Object delegate) {
        this.delegate = (io.vertx.ext.web.openapi.RouterBuilder)delegate;
    }

    public io.vertx.ext.web.openapi.RouterBuilder getDelegate() {
        return this.delegate;
    }

    public Operation operation(String operationId) {
        Operation ret = Operation.newInstance(this.delegate.operation(operationId));
        return ret;
    }

    public List<Operation> operations() {
        List<Operation> ret = this.delegate.operations().stream().map(elt -> Operation.newInstance(elt)).collect(Collectors.toList());
        return ret;
    }

    public RouterBuilder bodyHandler(BodyHandler bodyHandler) {
        this.delegate.bodyHandler(bodyHandler.getDelegate());
        return this;
    }

    public RouterBuilder rootHandler(final Handler<RoutingContext> rootHandler) {
        this.delegate.rootHandler((Handler)new Handler<io.vertx.ext.web.RoutingContext>(){

            public void handle(io.vertx.ext.web.RoutingContext event) {
                rootHandler.handle((Object)RoutingContext.newInstance(event));
            }
        });
        return this;
    }

    public RouterBuilder mountServicesFromExtensions() {
        this.delegate.mountServicesFromExtensions();
        return this;
    }

    public RouterBuilder setOptions(RouterBuilderOptions options) {
        this.delegate.setOptions(options);
        return this;
    }

    public RouterBuilderOptions getOptions() {
        RouterBuilderOptions ret = this.delegate.getOptions();
        return ret;
    }

    public OpenAPIHolder getOpenAPI() {
        OpenAPIHolder ret = OpenAPIHolder.newInstance(this.delegate.getOpenAPI());
        return ret;
    }

    public SchemaRouter getSchemaRouter() {
        SchemaRouter ret = SchemaRouter.newInstance(this.delegate.getSchemaRouter());
        return ret;
    }

    public SchemaParser getSchemaParser() {
        SchemaParser ret = SchemaParser.newInstance(this.delegate.getSchemaParser());
        return ret;
    }

    public RouterBuilder serviceExtraPayloadMapper(final Function<RoutingContext, JsonObject> serviceExtraPayloadMapper) {
        this.delegate.serviceExtraPayloadMapper((Function)new Function<io.vertx.ext.web.RoutingContext, JsonObject>(){

            @Override
            public JsonObject apply(io.vertx.ext.web.RoutingContext arg) {
                JsonObject ret = (JsonObject)serviceExtraPayloadMapper.apply(RoutingContext.newInstance(arg));
                return ret;
            }
        });
        return this;
    }

    public SecurityScheme securityHandler(String securitySchemeName) {
        SecurityScheme ret = SecurityScheme.newInstance(this.delegate.securityHandler(securitySchemeName));
        return ret;
    }

    public Router createRouter() {
        Router ret = Router.newInstance(this.delegate.createRouter());
        return ret;
    }

    public static Single<RouterBuilder> create(io.vertx.rxjava3.core.Vertx vertx, String url) {
        Single ret = RouterBuilder.rxCreate(vertx, url);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<RouterBuilder> rxCreate(io.vertx.rxjava3.core.Vertx vertx, String url) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (Handler)new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>(){

            public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public static Single<RouterBuilder> create(io.vertx.rxjava3.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        Single ret = RouterBuilder.rxCreate(vertx, url, options);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public static Single<RouterBuilder> rxCreate(io.vertx.rxjava3.core.Vertx vertx, String url, OpenAPILoaderOptions options) {
        return AsyncResultSingle.toSingle(handler -> io.vertx.ext.web.openapi.RouterBuilder.create((Vertx)vertx.getDelegate(), (String)url, (OpenAPILoaderOptions)options, (Handler)new Handler<AsyncResult<io.vertx.ext.web.openapi.RouterBuilder>>(){

            public void handle(AsyncResult<io.vertx.ext.web.openapi.RouterBuilder> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)RouterBuilder.newInstance((io.vertx.ext.web.openapi.RouterBuilder)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public RouterBuilder securityHandler(String securitySchemeName, AuthenticationHandler handler) {
        this.delegate.securityHandler(securitySchemeName, handler.getDelegate());
        return this;
    }

    public static RouterBuilder newInstance(io.vertx.ext.web.openapi.RouterBuilder arg) {
        return arg != null ? new RouterBuilder(arg) : null;
    }
}

