/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.sqlclient;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.CompletableHelper;
import io.vertx.rxjava3.SingleHelper;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.sqlclient.PreparedStatement;
import io.vertx.rxjava3.sqlclient.SqlClient;
import io.vertx.rxjava3.sqlclient.Transaction;
import io.vertx.rxjava3.sqlclient.spi.DatabaseMetadata;

@RxGen(value=io.vertx.sqlclient.SqlConnection.class)
public class SqlConnection
extends SqlClient {
    public static final TypeArg<SqlConnection> __TYPE_ARG = new TypeArg(obj -> new SqlConnection((io.vertx.sqlclient.SqlConnection)obj), SqlConnection::getDelegate);
    private final io.vertx.sqlclient.SqlConnection delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlConnection that = (SqlConnection)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public SqlConnection(io.vertx.sqlclient.SqlConnection delegate) {
        super((io.vertx.sqlclient.SqlClient)delegate);
        this.delegate = delegate;
    }

    public SqlConnection(Object delegate) {
        super((io.vertx.sqlclient.SqlClient)((io.vertx.sqlclient.SqlConnection)delegate));
        this.delegate = (io.vertx.sqlclient.SqlConnection)delegate;
    }

    public io.vertx.sqlclient.SqlConnection getDelegate() {
        return this.delegate;
    }

    public Single<PreparedStatement> prepare(String sql) {
        Single ret = this.rxPrepare(sql);
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<PreparedStatement> rxPrepare(String sql) {
        return AsyncResultSingle.toSingle(handler -> this.delegate.prepare(sql, (Handler)new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public SqlConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public SqlConnection closeHandler(Handler<Void> handler) {
        this.delegate.closeHandler(handler);
        return this;
    }

    public Single<Transaction> begin() {
        Single ret = this.rxBegin();
        ret = ret.cache();
        ret.subscribe(SingleHelper.nullObserver());
        return ret;
    }

    public Single<Transaction> rxBegin() {
        return AsyncResultSingle.toSingle(handler -> this.delegate.begin((Handler)new Handler<AsyncResult<io.vertx.sqlclient.Transaction>>(){

            public void handle(AsyncResult<io.vertx.sqlclient.Transaction> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)Transaction.newInstance((io.vertx.sqlclient.Transaction)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    @Override
    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe(CompletableHelper.nullObserver());
        return ret;
    }

    @Override
    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public DatabaseMetadata databaseMetadata() {
        DatabaseMetadata ret = DatabaseMetadata.newInstance(this.delegate.databaseMetadata());
        return ret;
    }

    public static SqlConnection newInstance(io.vertx.sqlclient.SqlConnection arg) {
        return arg != null ? new SqlConnection(arg) : null;
    }
}

