/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.core.net;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rxjava3.core.metrics.Measured;
import io.vertx.rxjava3.core.net.NetSocket;
import io.vertx.rxjava3.core.net.SocketAddress;
import io.vertx.rxjava3.impl.AsyncResultCompletable;
import io.vertx.rxjava3.impl.AsyncResultSingle;

@RxGen(value=io.vertx.core.net.NetClient.class)
public class NetClient
implements Measured {
    public static final TypeArg<NetClient> __TYPE_ARG = new TypeArg(obj -> new NetClient((io.vertx.core.net.NetClient)obj), NetClient::getDelegate);
    private final io.vertx.core.net.NetClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetClient that = (NetClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public NetClient(io.vertx.core.net.NetClient delegate) {
        this.delegate = delegate;
    }

    public NetClient(Object delegate) {
        this.delegate = (io.vertx.core.net.NetClient)delegate;
    }

    public io.vertx.core.net.NetClient getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public Single<NetSocket> connect(int port, String host) {
        Single ret = this.rxConnect(port, host);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<NetSocket> connect(int port, String host, String serverName) {
        Single ret = this.rxConnect(port, host, serverName);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<NetSocket> rxConnect(int port, String host, String serverName) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(port, host, serverName, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress) {
        Single ret = this.rxConnect(remoteAddress);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Single<NetSocket> connect(SocketAddress remoteAddress, String serverName) {
        Single ret = this.rxConnect(remoteAddress, serverName);
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Single<NetSocket> rxConnect(SocketAddress remoteAddress, String serverName) {
        return AsyncResultSingle.toSingle(connectHandler -> this.delegate.connect(remoteAddress.getDelegate(), serverName, (Handler)new Handler<AsyncResult<io.vertx.core.net.NetSocket>>(){

            public void handle(AsyncResult<io.vertx.core.net.NetSocket> ar) {
                if (ar.succeeded()) {
                    connectHandler.handle((Object)Future.succeededFuture((Object)NetSocket.newInstance((io.vertx.core.net.NetSocket)ar.result())));
                } else {
                    connectHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        }));
    }

    public Completable close() {
        Completable ret = this.rxClose();
        ret = ret.cache();
        ret.subscribe();
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.delegate.close(handler));
    }

    public static NetClient newInstance(io.vertx.core.net.NetClient arg) {
        return arg != null ? new NetClient(arg) : null;
    }
}

