/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.impl;

import io.reactivex.rxjava3.exceptions.CompositeException;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.streams.WriteStream;
import io.vertx.rxjava3.WriteStreamSubscriber;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public class WriteStreamSubscriberImpl<R, T>
implements WriteStreamSubscriber<R> {
    private static final int BATCH_SIZE = 16;
    private final WriteStream<T> writeStream;
    private final Function<R, T> mapping;
    private Subscription subscription;
    private int outstanding;
    private boolean done;
    private Consumer<? super Throwable> flowableErrorHandler;
    private Consumer<? super Throwable> writeStreamExceptionHandler;
    private Action writeStreamEndHandler;
    private Consumer<? super Throwable> writeStreamEndErrorHandler;

    public WriteStreamSubscriberImpl(WriteStream<T> writeStream, Function<R, T> mapping) {
        Objects.requireNonNull(writeStream, "writeStream");
        Objects.requireNonNull(mapping, "mapping");
        this.writeStream = writeStream;
        this.mapping = mapping;
    }

    public void onSubscribe(Subscription subscription) {
        Objects.requireNonNull(subscription, "subscription");
        if (!this.setSubscription(subscription)) {
            subscription.cancel();
            SubscriptionHelper.reportSubscriptionSet();
            return;
        }
        this.writeStream.exceptionHandler(t -> {
            Consumer<? super Throwable> c;
            this.setDone();
            this.getSubscription().cancel();
            WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
            synchronized (writeStreamSubscriberImpl) {
                c = this.writeStreamExceptionHandler;
            }
            if (c != null) {
                try {
                    c.accept(t);
                }
                catch (Throwable e) {
                    RxJavaPlugins.onError((Throwable)e);
                }
            }
        });
        this.writeStream.drainHandler(v -> this.requestMore());
        this.requestMore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(R r) {
        if (this.isDone()) {
            return;
        }
        if (r == null) {
            NullPointerException throwable = new NullPointerException("onNext called with null");
            try {
                this.getSubscription().cancel();
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                throwable = new CompositeException(new Throwable[]{throwable, t});
            }
            this.onError(throwable);
            return;
        }
        try {
            this.writeStream.write(this.mapping.apply(r));
            WriteStreamSubscriberImpl throwable = this;
            synchronized (throwable) {
                --this.outstanding;
            }
        }
        catch (Throwable t) {
            Throwable throwable;
            Exceptions.throwIfFatal((Throwable)t);
            try {
                this.getSubscription().cancel();
                throwable = t;
            }
            catch (Throwable t1) {
                Exceptions.throwIfFatal((Throwable)t1);
                throwable = new CompositeException(new Throwable[]{t, t1});
            }
            this.onError(throwable);
            return;
        }
        if (!this.writeStream.writeQueueFull()) {
            this.requestMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        Consumer<? super Throwable> c;
        if (!this.setDone()) {
            RxJavaPlugins.onError((Throwable)t);
            return;
        }
        Objects.requireNonNull(t, "onError called with null");
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            c = this.flowableErrorHandler;
        }
        try {
            if (c != null) {
                c.accept((Object)t);
            }
        }
        catch (Throwable t1) {
            Exceptions.throwIfFatal((Throwable)t1);
            RxJavaPlugins.onError((Throwable)t1);
        }
    }

    public void onComplete() {
        if (!this.setDone()) {
            return;
        }
        try {
            this.writeStream.end(this::writeStreamEnd);
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal((Throwable)t);
            RxJavaPlugins.onError((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamEnd(AsyncResult<Void> result) {
        block11: {
            try {
                Consumer<? super Throwable> c;
                if (result.succeeded()) {
                    Action a;
                    WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
                    synchronized (writeStreamSubscriberImpl) {
                        a = this.writeStreamEndHandler;
                    }
                    if (a != null) {
                        a.run();
                    }
                    break block11;
                }
                WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
                synchronized (writeStreamSubscriberImpl) {
                    c = this.writeStreamEndErrorHandler;
                }
                if (c != null) {
                    c.accept((Object)result.cause());
                }
            }
            catch (Throwable t) {
                Exceptions.throwIfFatal((Throwable)t);
                RxJavaPlugins.onError((Throwable)t);
            }
        }
    }

    private synchronized Subscription getSubscription() {
        return this.subscription;
    }

    private synchronized boolean setSubscription(Subscription subscription) {
        if (this.subscription == null) {
            this.subscription = subscription;
            return true;
        }
        return false;
    }

    private synchronized boolean isDone() {
        return this.done;
    }

    private synchronized boolean setDone() {
        return this.done ? false : (this.done = true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMore() {
        Subscription s = this.getSubscription();
        if (s == null) {
            return;
        }
        WriteStreamSubscriberImpl writeStreamSubscriberImpl = this;
        synchronized (writeStreamSubscriberImpl) {
            if (this.done || this.outstanding > 0) {
                return;
            }
            this.outstanding = 16;
        }
        s.request(16L);
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onError(Consumer<? super Throwable> handler) {
        this.flowableErrorHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamError(Consumer<? super Throwable> handler) {
        this.writeStreamExceptionHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEnd(Action handler) {
        this.writeStreamEndHandler = handler;
        return this;
    }

    @Override
    public synchronized WriteStreamSubscriber<R> onWriteStreamEndError(Consumer<? super Throwable> handler) {
        this.writeStreamEndErrorHandler = handler;
        return this;
    }
}

