/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import io.reactivex.rxjava3.core.Scheduler;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.streams.WriteStream;
import io.vertx.rxjava3.ContextScheduler;
import io.vertx.rxjava3.WriteStreamObserver;
import io.vertx.rxjava3.WriteStreamSubscriber;
import io.vertx.rxjava3.impl.WriteStreamObserverImpl;
import io.vertx.rxjava3.impl.WriteStreamSubscriberImpl;
import java.util.function.Function;

public class RxHelper {
    public static Scheduler scheduler(Vertx vertx) {
        return new ContextScheduler(vertx, false);
    }

    public static Scheduler scheduler(Context context) {
        return new ContextScheduler(context, false);
    }

    public static Scheduler blockingScheduler(Vertx vertx) {
        return new ContextScheduler(vertx, true);
    }

    public static Scheduler blockingScheduler(Vertx vertx, boolean ordered) {
        return new ContextScheduler(vertx, true, ordered);
    }

    public static Scheduler blockingScheduler(WorkerExecutor executor) {
        return new ContextScheduler(executor, false);
    }

    public static <T> WriteStreamSubscriber<T> toSubscriber(WriteStream<T> stream) {
        return RxHelper.toSubscriber(stream, Function.identity());
    }

    public static <R, T> WriteStreamSubscriber<R> toSubscriber(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamSubscriberImpl<R, T>(stream, mapping);
    }

    public static <T> WriteStreamObserver<T> toObserver(WriteStream<T> stream) {
        return RxHelper.toObserver(stream, Function.identity());
    }

    public static <R, T> WriteStreamObserver<R> toObserver(WriteStream<T> stream, Function<R, T> mapping) {
        return new WriteStreamObserverImpl<R, T>(stream, mapping);
    }
}

