/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3.impl;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class AsyncResultMaybe<T, U>
extends Maybe<T> {
    private final Consumer<Handler<AsyncResult<U>>> subscriptionConsumer;
    private final Function<U, T> mapping;

    public static <T> Maybe<T> toMaybe(Consumer<Handler<AsyncResult<T>>> subscriptionConsumer) {
        return RxJavaPlugins.onAssembly(new AsyncResultMaybe(subscriptionConsumer, Function.identity()));
    }

    public static <T, U> Maybe<T> toMaybe(Future<U> future, Function<U, T> mapping) {
        if (future == null) {
            return Maybe.error((Throwable)new NullPointerException());
        }
        return RxJavaPlugins.onAssembly(new AsyncResultMaybe<T, U>(arg_0 -> future.onComplete(arg_0), mapping));
    }

    private AsyncResultMaybe(Consumer<Handler<AsyncResult<U>>> subscriptionConsumer, Function<U, T> mapping) {
        this.subscriptionConsumer = subscriptionConsumer;
        this.mapping = mapping;
    }

    protected void subscribeActual(MaybeObserver<? super T> observer) {
        block5: {
            final AtomicBoolean disposed = new AtomicBoolean();
            observer.onSubscribe(new Disposable(){

                public void dispose() {
                    disposed.set(true);
                }

                public boolean isDisposed() {
                    return disposed.get();
                }
            });
            if (!disposed.get()) {
                try {
                    this.subscriptionConsumer.accept(ar -> {
                        block9: {
                            if (!disposed.getAndSet(true)) {
                                if (ar.succeeded()) {
                                    try {
                                        T val = this.mapping.apply(ar.result());
                                        if (val != null) {
                                            observer.onSuccess(val);
                                            break block9;
                                        }
                                        observer.onComplete();
                                    }
                                    catch (Throwable t) {
                                        Exceptions.throwIfFatal((Throwable)t);
                                        RxJavaPlugins.onError((Throwable)t);
                                    }
                                } else if (ar.failed()) {
                                    try {
                                        observer.onError(ar.cause());
                                    }
                                    catch (Throwable t) {
                                        Exceptions.throwIfFatal((Throwable)t);
                                        RxJavaPlugins.onError((Throwable)t);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (disposed.getAndSet(true)) break block5;
                    try {
                        observer.onError((Throwable)e);
                    }
                    catch (Throwable t) {
                        Exceptions.throwIfFatal((Throwable)t);
                        RxJavaPlugins.onError((Throwable)t);
                    }
                }
            }
        }
    }
}

