/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava3;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.core.SingleTransformer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.rxjava3.impl.AsyncResultSingle;
import io.vertx.rxjava3.impl.SingleUnmarshaller;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;

public class SingleHelper {
    public static final SingleObserver<?> NULL_OBSERVER = new SingleObserver<Object>(){

        public void onSubscribe(@NonNull Disposable d) {
        }

        public void onSuccess(@NonNull Object o) {
        }

        public void onError(@NonNull Throwable e) {
        }
    };

    public static <T> SingleObserver<T> nullObserver() {
        return NULL_OBSERVER;
    }

    public static <T> Single<T> toSingle(Consumer<Handler<AsyncResult<T>>> handler) {
        return AsyncResultSingle.toSingle(handler);
    }

    public static <T> SingleObserver<T> toObserver(final Handler<AsyncResult<T>> handler) {
        final AtomicBoolean completed = new AtomicBoolean();
        return new SingleObserver<T>(){

            public void onSubscribe(@NonNull Disposable d) {
            }

            public void onSuccess(@NonNull T item) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.succeededFuture(item));
                }
            }

            public void onError(Throwable error) {
                if (completed.compareAndSet(false, true)) {
                    handler.handle((Object)Future.failedFuture((Throwable)error));
                }
            }
        };
    }

    public static <T> Future<T> toFuture(Single<T> single) {
        Promise promise = Promise.promise();
        single.subscribe(arg_0 -> ((Promise)promise).complete(arg_0), arg_0 -> ((Promise)promise).fail(arg_0));
        return promise.future();
    }

    public static <T, U> Future<U> toFuture(Single<T> single, Function<T, U> adapter) {
        return SingleHelper.toFuture(single.map(adapter::apply));
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(Class<T> mappedType) {
        return new SingleUnmarshaller(Function.identity(), mappedType);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef) {
        return new SingleUnmarshaller(Function.identity(), mappedTypeRef);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(Class<T> mappedType, ObjectCodec mapper) {
        return new SingleUnmarshaller(Function.identity(), mappedType, mapper);
    }

    public static <T> SingleTransformer<Buffer, T> unmarshaller(TypeReference<T> mappedTypeRef, ObjectCodec mapper) {
        return new SingleUnmarshaller(Function.identity(), mappedTypeRef, mapper);
    }
}

