/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.grpc.common;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.InvalidMessageException;
import io.vertx.grpc.common.WireFormat;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.function.Function;

@RxGen(value=io.vertx.grpc.common.GrpcReadStream.class)
public class GrpcReadStream<T>
implements RxDelegate,
ReadStream<T> {
    public static final TypeArg<GrpcReadStream> __TYPE_ARG = new TypeArg(obj -> new GrpcReadStream((io.vertx.grpc.common.GrpcReadStream)obj), GrpcReadStream::getDelegate);
    private final io.vertx.grpc.common.GrpcReadStream<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private Observable<T> observable;
    private Flowable<T> flowable;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcReadStream that = (GrpcReadStream)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public GrpcReadStream(io.vertx.grpc.common.GrpcReadStream delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public GrpcReadStream(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.grpc.common.GrpcReadStream)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.grpc.common.GrpcReadStream getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<T> toObservable() {
        if (this.observable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.observable = ObservableHelper.toObservable(this.delegate, (Function)conv);
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<T> toFlowable() {
        if (this.flowable == null) {
            Function conv = this.__typeArg_0.wrap;
            this.flowable = FlowableHelper.toFlowable(this.delegate, (Function)conv);
        }
        return this.flowable;
    }

    @Override
    public Pipe<T> pipe() {
        Pipe<T> ret = Pipe.newInstance(this.delegate.pipe(), this.__typeArg_0);
        return ret;
    }

    @Override
    public Future<Void> pipeTo(WriteStream<T> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<T> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    public MultiMap headers() {
        MultiMap ret = this.delegate.headers();
        return ret;
    }

    public String encoding() {
        String ret = this.delegate.encoding();
        return ret;
    }

    public WireFormat format() {
        WireFormat ret = this.delegate.format();
        return ret;
    }

    public GrpcReadStream<T> messageHandler(Handler<GrpcMessage> handler) {
        this.delegate.messageHandler(handler);
        return this;
    }

    public GrpcReadStream<T> errorHandler(Handler<GrpcError> handler) {
        this.delegate.errorHandler(handler);
        return this;
    }

    @Override
    public GrpcReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    @Override
    public GrpcReadStream<T> handler(Handler<T> handler) {
        this.delegate.handler(Helper.convertHandler(handler, event -> this.__typeArg_0.wrap(event)));
        return this;
    }

    @Override
    public GrpcReadStream<T> pause() {
        this.delegate.pause();
        return this;
    }

    @Override
    public GrpcReadStream<T> resume() {
        this.delegate.resume();
        return this;
    }

    @Override
    public GrpcReadStream<T> fetch(long l) {
        this.delegate.fetch(l);
        return this;
    }

    @Override
    public GrpcReadStream<T> endHandler(Handler<Void> handler) {
        this.delegate.endHandler(handler);
        return this;
    }

    public Future<T> last() {
        Future ret = this.delegate.last().map(val -> this.__typeArg_0.wrap(val));
        return ret;
    }

    public Single<T> rxLast() {
        return AsyncResultSingle.toSingle($handler -> this.last().onComplete($handler));
    }

    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    public GrpcReadStream<T> invalidMessageHandler(Handler<InvalidMessageException> handler) {
        GrpcReadStream<T> ret = GrpcReadStream.newInstance(this.delegate.invalidMessageHandler(handler), this.__typeArg_0);
        return ret;
    }

    public static <T> GrpcReadStream<T> newInstance(io.vertx.grpc.common.GrpcReadStream arg) {
        return arg != null ? new GrpcReadStream<T>(arg) : null;
    }

    public static <T> GrpcReadStream<T> newInstance(io.vertx.grpc.common.GrpcReadStream arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new GrpcReadStream<T>(arg, __typeArg_T) : null;
    }
}

