/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.web.client;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.streams.ReadStream;
import io.vertx.reactivex.ext.web.client.HttpResponse;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import io.vertx.reactivex.ext.web.multipart.MultipartForm;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.reactivex.impl.ReadStreamSubscriber;
import io.vertx.reactivex.uritemplate.Variables;
import java.util.List;
import java.util.Map;

@RxGen(value=io.vertx.ext.web.client.HttpRequest.class)
public class HttpRequest<T>
implements RxDelegate {
    public static final TypeArg<HttpRequest> __TYPE_ARG = new TypeArg(obj -> new HttpRequest((io.vertx.ext.web.client.HttpRequest)obj), HttpRequest::getDelegate);
    private final io.vertx.ext.web.client.HttpRequest<T> delegate;
    public final TypeArg<T> __typeArg_0;
    private MultiMap cached_0;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequest that = (HttpRequest)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpRequest(io.vertx.ext.web.client.HttpRequest delegate) {
        this.delegate = delegate;
        this.__typeArg_0 = TypeArg.unknown();
    }

    public HttpRequest(Object delegate, TypeArg<T> typeArg_0) {
        this.delegate = (io.vertx.ext.web.client.HttpRequest)delegate;
        this.__typeArg_0 = typeArg_0;
    }

    public io.vertx.ext.web.client.HttpRequest getDelegate() {
        return this.delegate;
    }

    public HttpRequest<T> method(HttpMethod value) {
        this.delegate.method(value);
        return this;
    }

    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public HttpRequest<T> port(int value) {
        this.delegate.port(value);
        return this;
    }

    public int port() {
        int ret = this.delegate.port();
        return ret;
    }

    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        HttpRequest ret = HttpRequest.newInstance(this.delegate.as(responseCodec.getDelegate()), responseCodec.__typeArg_0);
        return ret;
    }

    public BodyCodec<T> bodyCodec() {
        BodyCodec<T> ret = BodyCodec.newInstance(this.delegate.bodyCodec(), this.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> host(String value) {
        this.delegate.host(value);
        return this;
    }

    public String host() {
        String ret = this.delegate.host();
        return ret;
    }

    public HttpRequest<T> virtualHost(String value) {
        this.delegate.virtualHost(value);
        return this;
    }

    public String virtualHost() {
        String ret = this.delegate.virtualHost();
        return ret;
    }

    public HttpRequest<T> uri(String value) {
        this.delegate.uri(value);
        return this;
    }

    public String uri() {
        String ret = this.delegate.uri();
        return ret;
    }

    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.delegate.putHeaders(headers);
        return this;
    }

    public HttpRequest<T> putHeader(String name, String value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public MultiMap headers() {
        MultiMap ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = this.delegate.headers();
        return ret;
    }

    public HttpRequest<T> basicAuthentication(String id, String password) {
        this.delegate.basicAuthentication(id, password);
        return this;
    }

    public HttpRequest<T> basicAuthentication(Buffer id, Buffer password) {
        this.delegate.basicAuthentication(id, password);
        return this;
    }

    public HttpRequest<T> bearerTokenAuthentication(String bearerToken) {
        this.delegate.bearerTokenAuthentication(bearerToken);
        return this;
    }

    public HttpRequest<T> ssl(Boolean value) {
        this.delegate.ssl(value);
        return this;
    }

    public Boolean ssl() {
        Boolean ret = this.delegate.ssl();
        return ret;
    }

    public HttpRequest<T> timeout(long value) {
        this.delegate.timeout(value);
        return this;
    }

    public long timeout() {
        long ret = this.delegate.timeout();
        return ret;
    }

    public HttpRequest<T> idleTimeout(long timeout) {
        this.delegate.idleTimeout(timeout);
        return this;
    }

    public long idleTimeout() {
        long ret = this.delegate.idleTimeout();
        return ret;
    }

    public HttpRequest<T> connectTimeout(long timeout) {
        this.delegate.connectTimeout(timeout);
        return this;
    }

    public long connectTimeout() {
        long ret = this.delegate.connectTimeout();
        return ret;
    }

    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.delegate.addQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.delegate.setQueryParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, String paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, List<String> paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> setTemplateParam(String paramName, Map<String, String> paramValue) {
        this.delegate.setTemplateParam(paramName, paramValue);
        return this;
    }

    public HttpRequest<T> followRedirects(boolean value) {
        this.delegate.followRedirects(value);
        return this;
    }

    public boolean followRedirects() {
        boolean ret = this.delegate.followRedirects();
        return ret;
    }

    public HttpRequest<T> routingKey(String key) {
        this.delegate.routingKey(key);
        return this;
    }

    public String routingKey() {
        String ret = this.delegate.routingKey();
        return ret;
    }

    public HttpRequest<T> proxy(ProxyOptions proxyOptions) {
        this.delegate.proxy(proxyOptions);
        return this;
    }

    public ProxyOptions proxy() {
        ProxyOptions ret = this.delegate.proxy();
        return ret;
    }

    public MultiMap queryParams() {
        MultiMap ret = this.delegate.queryParams();
        return ret;
    }

    public Variables templateParams() {
        Variables ret = Variables.newInstance(this.delegate.templateParams());
        return ret;
    }

    public HttpRequest<T> copy() {
        HttpRequest<T> ret = HttpRequest.newInstance(this.delegate.copy(), this.__typeArg_0);
        return ret;
    }

    public HttpRequest<T> multipartMixed(boolean allow) {
        this.delegate.multipartMixed(allow);
        return this;
    }

    public boolean multipartMixed() {
        boolean ret = this.delegate.multipartMixed();
        return ret;
    }

    public HttpRequest<T> traceOperation(String traceOperation) {
        this.delegate.traceOperation(traceOperation);
        return this;
    }

    public String traceOperation() {
        String ret = this.delegate.traceOperation();
        return ret;
    }

    public Future<HttpResponse<T>> sendStream(ReadStream<Buffer> body) {
        Future ret = this.delegate.sendStream(body.getDelegate()).map(val -> HttpResponse.newInstance((io.vertx.ext.web.client.HttpResponse)val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendStream(ReadStream<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.sendStream(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendStream(Flowable<Buffer> body) {
        Future ret = this.delegate.sendStream(ReadStreamSubscriber.asReadStream(body, obj -> obj).resume()).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendStream(Flowable<Buffer> body) {
        return AsyncResultSingle.toSingle($handler -> this.sendStream(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendBuffer(Buffer body) {
        Future ret = this.delegate.sendBuffer(body).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendBuffer(Buffer body) {
        return AsyncResultSingle.toSingle($handler -> this.sendBuffer(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendJsonObject(JsonObject body) {
        Future ret = this.delegate.sendJsonObject(body).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendJsonObject(JsonObject body) {
        return AsyncResultSingle.toSingle($handler -> this.sendJsonObject(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendJson(Object body) {
        Future ret = this.delegate.sendJson(body).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendJson(Object body) {
        return AsyncResultSingle.toSingle($handler -> this.sendJson(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendForm(MultiMap body) {
        Future ret = this.delegate.sendForm(body).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body) {
        return AsyncResultSingle.toSingle($handler -> this.sendForm(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendForm(MultiMap body, String charset) {
        Future ret = this.delegate.sendForm(body, charset).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendForm(MultiMap body, String charset) {
        return AsyncResultSingle.toSingle($handler -> this.sendForm(body, charset).onComplete($handler));
    }

    public Future<HttpResponse<T>> sendMultipartForm(MultipartForm body) {
        Future ret = this.delegate.sendMultipartForm(body.getDelegate()).map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSendMultipartForm(MultipartForm body) {
        return AsyncResultSingle.toSingle($handler -> this.sendMultipartForm(body).onComplete($handler));
    }

    public Future<HttpResponse<T>> send() {
        Future ret = this.delegate.send().map(val -> HttpResponse.newInstance(val, this.__typeArg_0));
        return ret;
    }

    public Single<HttpResponse<T>> rxSend() {
        return AsyncResultSingle.toSingle($handler -> this.send().onComplete($handler));
    }

    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.delegate.putHeader(name, value);
        return this;
    }

    public HttpRequest<T> authentication(Credentials credentials) {
        this.delegate.authentication(credentials);
        return this;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg) {
        return arg != null ? new HttpRequest<T>(arg) : null;
    }

    public static <T> HttpRequest<T> newInstance(io.vertx.ext.web.client.HttpRequest arg, TypeArg<T> __typeArg_T) {
        return arg != null ? new HttpRequest<T>(arg, __typeArg_T) : null;
    }
}

