/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.vertx.core.Expectation;
import java.util.function.Function;

public final class ExpectationTransformer<T, U>
implements SingleTransformer<T, T> {
    private final Expectation<U> expectation;
    private final Function<T, U> unwrapper;

    public ExpectationTransformer(Expectation<U> expectation, Function<T, U> unwrapper) {
        this.expectation = expectation;
        this.unwrapper = unwrapper;
    }

    public SingleSource<T> apply(Single<T> upstream) {
        return upstream.flatMap(t -> {
            U u = this.unwrapper.apply(t);
            if (this.expectation.test(u)) {
                return Single.just((Object)t);
            }
            Throwable desc = this.expectation.describe(u);
            return Single.error((Throwable)desc);
        });
    }
}

