/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.FlowableHelper;
import io.vertx.reactivex.ObservableHelper;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpRequestHead;
import io.vertx.reactivex.core.http.HttpServerFileUpload;
import io.vertx.reactivex.core.http.HttpServerResponse;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.net.NetSocket;
import io.vertx.reactivex.core.streams.Pipe;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.Set;
import javax.net.ssl.SSLSession;

@RxGen(value=io.vertx.core.http.HttpServerRequest.class)
public class HttpServerRequest
extends HttpRequestHead
implements RxDelegate,
io.vertx.reactivex.core.streams.ReadStream<Buffer> {
    public static final TypeArg<HttpServerRequest> __TYPE_ARG = new TypeArg(obj -> new HttpServerRequest((io.vertx.core.http.HttpServerRequest)obj), HttpServerRequest::getDelegate);
    private final io.vertx.core.http.HttpServerRequest delegate;
    private Observable<Buffer> observable;
    private Flowable<Buffer> flowable;
    private static final TypeArg<NetSocket> TYPE_ARG_0 = new TypeArg(o1 -> NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());
    private static final TypeArg<ServerWebSocket> TYPE_ARG_1 = new TypeArg(o1 -> ServerWebSocket.newInstance((io.vertx.core.http.ServerWebSocket)o1), o1 -> o1.getDelegate());
    private HttpServerResponse cached_0;
    private MultiMap cached_1;
    private SocketAddress cached_2;
    private SocketAddress cached_3;
    private MultiMap cached_4;
    private Integer cached_5;
    private HttpConnection cached_6;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServerRequest that = (HttpServerRequest)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServerRequest(io.vertx.core.http.HttpServerRequest delegate) {
        super((io.vertx.core.http.HttpRequestHead)delegate);
        this.delegate = delegate;
    }

    public HttpServerRequest(Object delegate) {
        super((io.vertx.core.http.HttpRequestHead)((io.vertx.core.http.HttpServerRequest)delegate));
        this.delegate = (io.vertx.core.http.HttpServerRequest)delegate;
    }

    public io.vertx.core.http.HttpServerRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Buffer> toObservable() {
        if (this.observable == null) {
            this.observable = ObservableHelper.toObservable((ReadStream)this.getDelegate());
        }
        return this.observable;
    }

    @Override
    public synchronized Flowable<Buffer> toFlowable() {
        if (this.flowable == null) {
            this.flowable = FlowableHelper.toFlowable((ReadStream)this.getDelegate());
        }
        return this.flowable;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TypeArg.unknown());
        return ret;
    }

    @Override
    public Future<Void> pipeTo(WriteStream<Buffer> dst) {
        Future ret = this.delegate.pipeTo(dst.getDelegate()).map(val -> val);
        return ret;
    }

    @Override
    public Completable rxPipeTo(WriteStream<Buffer> dst) {
        return AsyncResultCompletable.toCompletable($handler -> this.pipeTo(dst).onComplete($handler));
    }

    @Override
    public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServerRequest handler(Handler<Buffer> handler) {
        this.delegate.handler(handler);
        return this;
    }

    public HttpServerRequest pause() {
        this.delegate.pause();
        return this;
    }

    public HttpServerRequest resume() {
        this.delegate.resume();
        return this;
    }

    public HttpServerRequest fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public HttpServerRequest endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public HttpVersion version() {
        HttpVersion ret = this.delegate.version();
        return ret;
    }

    @Override
    public HttpMethod method() {
        HttpMethod ret = this.delegate.method();
        return ret;
    }

    public boolean isSSL() {
        boolean ret = this.delegate.isSSL();
        return ret;
    }

    public String scheme() {
        String ret = this.delegate.scheme();
        return ret;
    }

    public HostAndPort authority() {
        HostAndPort ret = this.delegate.authority();
        return ret;
    }

    public long bytesRead() {
        long ret = this.delegate.bytesRead();
        return ret;
    }

    public HttpServerResponse response() {
        HttpServerResponse ret;
        if (this.cached_0 != null) {
            return this.cached_0;
        }
        this.cached_0 = ret = HttpServerResponse.newInstance(this.delegate.response());
        return ret;
    }

    public HttpServerRequest setParamsCharset(String charset) {
        this.delegate.setParamsCharset(charset);
        return this;
    }

    public String getParamsCharset() {
        String ret = this.delegate.getParamsCharset();
        return ret;
    }

    public MultiMap params() {
        MultiMap ret;
        if (this.cached_1 != null) {
            return this.cached_1;
        }
        this.cached_1 = ret = this.delegate.params();
        return ret;
    }

    public MultiMap params(boolean semicolonIsNormalChar) {
        MultiMap ret = this.delegate.params(semicolonIsNormalChar);
        return ret;
    }

    public String getParam(String paramName) {
        String ret = this.delegate.getParam(paramName);
        return ret;
    }

    public String getParam(String paramName, String defaultValue) {
        String ret = this.delegate.getParam(paramName, defaultValue);
        return ret;
    }

    public SocketAddress remoteAddress() {
        SocketAddress ret;
        if (this.cached_2 != null) {
            return this.cached_2;
        }
        this.cached_2 = ret = this.delegate.remoteAddress();
        return ret;
    }

    public SocketAddress localAddress() {
        SocketAddress ret;
        if (this.cached_3 != null) {
            return this.cached_3;
        }
        this.cached_3 = ret = this.delegate.localAddress();
        return ret;
    }

    public String absoluteURI() {
        String ret = this.delegate.absoluteURI();
        return ret;
    }

    public HttpServerRequest bodyHandler(Handler<Buffer> bodyHandler) {
        this.delegate.bodyHandler(bodyHandler);
        return this;
    }

    public Future<Buffer> body() {
        Future ret = this.delegate.body().map(val -> val);
        return ret;
    }

    public Single<Buffer> rxBody() {
        return AsyncResultSingle.toSingle($handler -> this.body().onComplete($handler));
    }

    public Future<Void> end() {
        Future ret = this.delegate.end().map(val -> val);
        return ret;
    }

    public Completable rxEnd() {
        return AsyncResultCompletable.toCompletable($handler -> this.end().onComplete($handler));
    }

    public Future<NetSocket> toNetSocket() {
        Future ret = this.delegate.toNetSocket().map(val -> NetSocket.newInstance(val));
        return ret;
    }

    public Single<NetSocket> rxToNetSocket() {
        return AsyncResultSingle.toSingle($handler -> this.toNetSocket().onComplete($handler));
    }

    public HttpServerRequest setExpectMultipart(boolean expect) {
        this.delegate.setExpectMultipart(expect);
        return this;
    }

    public boolean isExpectMultipart() {
        boolean ret = this.delegate.isExpectMultipart();
        return ret;
    }

    public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
        this.delegate.uploadHandler(Helper.convertHandler(uploadHandler, event -> HttpServerFileUpload.newInstance(event)));
        return this;
    }

    public MultiMap formAttributes() {
        MultiMap ret;
        if (this.cached_4 != null) {
            return this.cached_4;
        }
        this.cached_4 = ret = this.delegate.formAttributes();
        return ret;
    }

    public String getFormAttribute(String attributeName) {
        String ret = this.delegate.getFormAttribute(attributeName);
        return ret;
    }

    public int streamId() {
        if (this.cached_5 != null) {
            return this.cached_5;
        }
        int ret = this.delegate.streamId();
        this.cached_5 = ret;
        return ret;
    }

    public boolean canUpgradeToWebSocket() {
        boolean ret = this.delegate.canUpgradeToWebSocket();
        return ret;
    }

    public Future<ServerWebSocket> toWebSocket() {
        Future ret = this.delegate.toWebSocket().map(val -> ServerWebSocket.newInstance(val));
        return ret;
    }

    public Single<ServerWebSocket> rxToWebSocket() {
        return AsyncResultSingle.toSingle($handler -> this.toWebSocket().onComplete($handler));
    }

    public boolean isEnded() {
        boolean ret = this.delegate.isEnded();
        return ret;
    }

    public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
        this.delegate.customFrameHandler(handler);
        return this;
    }

    public HttpConnection connection() {
        HttpConnection ret;
        if (this.cached_6 != null) {
            return this.cached_6;
        }
        this.cached_6 = ret = HttpConnection.newInstance(this.delegate.connection());
        return ret;
    }

    public StreamPriority streamPriority() {
        StreamPriority ret = this.delegate.streamPriority();
        return ret;
    }

    public HttpServerRequest streamPriorityHandler(Handler<StreamPriority> handler) {
        this.delegate.streamPriorityHandler(handler);
        return this;
    }

    public Cookie getCookie(String name) {
        Cookie ret = this.delegate.getCookie(name);
        return ret;
    }

    public Cookie getCookie(String name, String domain, String path) {
        Cookie ret = this.delegate.getCookie(name, domain, path);
        return ret;
    }

    public int cookieCount() {
        int ret = this.delegate.cookieCount();
        return ret;
    }

    public Set<Cookie> cookies(String name) {
        Set ret = this.delegate.cookies(name);
        return ret;
    }

    public Set<Cookie> cookies() {
        Set ret = this.delegate.cookies();
        return ret;
    }

    public HttpServerRequest routed(String route) {
        this.delegate.routed(route);
        return this;
    }

    public SSLSession sslSession() {
        SSLSession ret = this.delegate.sslSession();
        return ret;
    }

    public static HttpServerRequest newInstance(io.vertx.core.http.HttpServerRequest arg) {
        return arg != null ? new HttpServerRequest(arg) : null;
    }
}

