/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.http;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.net.ServerSSLOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrafficShapingOptions;
import io.vertx.lang.reactivex.Helper;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.http.HttpConnection;
import io.vertx.reactivex.core.http.HttpServerRequest;
import io.vertx.reactivex.core.http.ServerWebSocket;
import io.vertx.reactivex.core.http.ServerWebSocketHandshake;
import io.vertx.reactivex.core.metrics.Measured;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.concurrent.TimeUnit;

@RxGen(value=io.vertx.core.http.HttpServer.class)
public class HttpServer
implements RxDelegate,
Measured {
    public static final TypeArg<HttpServer> __TYPE_ARG = new TypeArg(obj -> new HttpServer((io.vertx.core.http.HttpServer)obj), HttpServer::getDelegate);
    private final io.vertx.core.http.HttpServer delegate;
    private static final TypeArg<HttpServer> TYPE_ARG_0 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_1 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_2 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());
    private static final TypeArg<HttpServer> TYPE_ARG_3 = new TypeArg(o1 -> HttpServer.newInstance((io.vertx.core.http.HttpServer)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpServer that = (HttpServer)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public HttpServer(io.vertx.core.http.HttpServer delegate) {
        this.delegate = delegate;
    }

    public HttpServer(Object delegate) {
        this.delegate = (io.vertx.core.http.HttpServer)delegate;
    }

    public io.vertx.core.http.HttpServer getDelegate() {
        return this.delegate;
    }

    @Override
    public boolean isMetricsEnabled() {
        boolean ret = this.delegate.isMetricsEnabled();
        return ret;
    }

    public HttpServer requestHandler(Handler<HttpServerRequest> handler) {
        this.delegate.requestHandler(Helper.convertHandler(handler, event -> HttpServerRequest.newInstance(event)));
        return this;
    }

    public HttpServer invalidRequestHandler(Handler<HttpServerRequest> handler) {
        HttpServer ret = HttpServer.newInstance(this.delegate.invalidRequestHandler(Helper.convertHandler(handler, event -> HttpServerRequest.newInstance(event))));
        return ret;
    }

    public HttpServer connectionHandler(Handler<HttpConnection> handler) {
        this.delegate.connectionHandler(Helper.convertHandler(handler, event -> HttpConnection.newInstance(event)));
        return this;
    }

    public HttpServer webSocketHandshakeHandler(Handler<ServerWebSocketHandshake> handler) {
        this.delegate.webSocketHandshakeHandler(Helper.convertHandler(handler, event -> ServerWebSocketHandshake.newInstance(event)));
        return this;
    }

    public HttpServer exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public HttpServer webSocketHandler(Handler<ServerWebSocket> handler) {
        this.delegate.webSocketHandler(Helper.convertHandler(handler, event -> ServerWebSocket.newInstance(event)));
        return this;
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions options) {
        Future ret = this.delegate.updateSSLOptions(options).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options).onComplete($handler));
    }

    public Future<Boolean> updateSSLOptions(ServerSSLOptions options, boolean force) {
        Future ret = this.delegate.updateSSLOptions(options, force).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateSSLOptions(ServerSSLOptions options, boolean force) {
        return AsyncResultSingle.toSingle($handler -> this.updateSSLOptions(options, force).onComplete($handler));
    }

    public Future<Boolean> updateTrafficShapingOptions(TrafficShapingOptions options) {
        Future ret = this.delegate.updateTrafficShapingOptions(options).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxUpdateTrafficShapingOptions(TrafficShapingOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.updateTrafficShapingOptions(options).onComplete($handler));
    }

    public Future<HttpServer> listen() {
        Future ret = this.delegate.listen().map(val -> HttpServer.newInstance(val));
        return ret;
    }

    public Single<HttpServer> rxListen() {
        return AsyncResultSingle.toSingle($handler -> this.listen().onComplete($handler));
    }

    public Future<HttpServer> listen(int port, String host) {
        Future ret = this.delegate.listen(port, host).map(val -> HttpServer.newInstance(val));
        return ret;
    }

    public Single<HttpServer> rxListen(int port, String host) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port, host).onComplete($handler));
    }

    public Future<HttpServer> listen(SocketAddress address) {
        Future ret = this.delegate.listen(address).map(val -> HttpServer.newInstance(val));
        return ret;
    }

    public Single<HttpServer> rxListen(SocketAddress address) {
        return AsyncResultSingle.toSingle($handler -> this.listen(address).onComplete($handler));
    }

    public Future<HttpServer> listen(int port) {
        Future ret = this.delegate.listen(port).map(val -> HttpServer.newInstance(val));
        return ret;
    }

    public Single<HttpServer> rxListen(int port) {
        return AsyncResultSingle.toSingle($handler -> this.listen(port).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public Future<Void> shutdown() {
        Future ret = this.delegate.shutdown().map(val -> val);
        return ret;
    }

    public Completable rxShutdown() {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown().onComplete($handler));
    }

    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        Future ret = this.delegate.shutdown(timeout, unit).map(val -> val);
        return ret;
    }

    public Completable rxShutdown(long timeout, TimeUnit unit) {
        return AsyncResultCompletable.toCompletable($handler -> this.shutdown(timeout, unit).onComplete($handler));
    }

    public int actualPort() {
        int ret = this.delegate.actualPort();
        return ret;
    }

    public static HttpServer newInstance(io.vertx.core.http.HttpServer arg) {
        return arg != null ? new HttpServer(arg) : null;
    }
}

