/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.dns;

import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.dns.DnsClient.class)
public class DnsClient
implements RxDelegate {
    public static final TypeArg<DnsClient> __TYPE_ARG = new TypeArg(obj -> new DnsClient((io.vertx.core.dns.DnsClient)obj), DnsClient::getDelegate);
    private final io.vertx.core.dns.DnsClient delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DnsClient that = (DnsClient)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DnsClient(io.vertx.core.dns.DnsClient delegate) {
        this.delegate = delegate;
    }

    public DnsClient(Object delegate) {
        this.delegate = (io.vertx.core.dns.DnsClient)delegate;
    }

    public io.vertx.core.dns.DnsClient getDelegate() {
        return this.delegate;
    }

    public Future<String> lookup(String name) {
        Future ret = this.delegate.lookup(name).map(val -> val);
        return ret;
    }

    public Maybe<String> rxLookup(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup(name).onComplete($handler));
    }

    public Future<String> lookup4(String name) {
        Future ret = this.delegate.lookup4(name).map(val -> val);
        return ret;
    }

    public Maybe<String> rxLookup4(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup4(name).onComplete($handler));
    }

    public Future<String> lookup6(String name) {
        Future ret = this.delegate.lookup6(name).map(val -> val);
        return ret;
    }

    public Maybe<String> rxLookup6(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.lookup6(name).onComplete($handler));
    }

    public Future<List<String>> resolveA(String name) {
        Future ret = this.delegate.resolveA(name).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxResolveA(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveA(name).onComplete($handler));
    }

    public Future<List<String>> resolveAAAA(String name) {
        Future ret = this.delegate.resolveAAAA(name).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxResolveAAAA(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveAAAA(name).onComplete($handler));
    }

    public Future<List<String>> resolveCNAME(String name) {
        Future ret = this.delegate.resolveCNAME(name).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxResolveCNAME(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveCNAME(name).onComplete($handler));
    }

    public Future<List<MxRecord>> resolveMX(String name) {
        Future ret = this.delegate.resolveMX(name).map(val -> val);
        return ret;
    }

    public Single<List<MxRecord>> rxResolveMX(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveMX(name).onComplete($handler));
    }

    public Future<List<String>> resolveTXT(String name) {
        Future ret = this.delegate.resolveTXT(name).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxResolveTXT(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveTXT(name).onComplete($handler));
    }

    public Future<String> resolvePTR(String name) {
        Future ret = this.delegate.resolvePTR(name).map(val -> val);
        return ret;
    }

    public Maybe<String> rxResolvePTR(String name) {
        return AsyncResultMaybe.toMaybe($handler -> this.resolvePTR(name).onComplete($handler));
    }

    public Future<List<String>> resolveNS(String name) {
        Future ret = this.delegate.resolveNS(name).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxResolveNS(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveNS(name).onComplete($handler));
    }

    public Future<List<SrvRecord>> resolveSRV(String name) {
        Future ret = this.delegate.resolveSRV(name).map(val -> val);
        return ret;
    }

    public Single<List<SrvRecord>> rxResolveSRV(String name) {
        return AsyncResultSingle.toSingle($handler -> this.resolveSRV(name).onComplete($handler));
    }

    public Future<String> reverseLookup(String ipaddress) {
        Future ret = this.delegate.reverseLookup(ipaddress).map(val -> val);
        return ret;
    }

    public Maybe<String> rxReverseLookup(String ipaddress) {
        return AsyncResultMaybe.toMaybe($handler -> this.reverseLookup(ipaddress).onComplete($handler));
    }

    public Future<Void> close() {
        Future ret = this.delegate.close().map(val -> val);
        return ret;
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable($handler -> this.close().onComplete($handler));
    }

    public static DnsClient newInstance(io.vertx.core.dns.DnsClient arg) {
        return arg != null ? new DnsClient(arg) : null;
    }
}

