/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core.file;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystemProps;
import io.vertx.core.file.OpenOptions;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.file.AsyncFile;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import java.util.List;

@RxGen(value=io.vertx.core.file.FileSystem.class)
public class FileSystem
implements RxDelegate {
    public static final TypeArg<FileSystem> __TYPE_ARG = new TypeArg(obj -> new FileSystem((io.vertx.core.file.FileSystem)obj), FileSystem::getDelegate);
    private final io.vertx.core.file.FileSystem delegate;
    private static final TypeArg<AsyncFile> TYPE_ARG_0 = new TypeArg(o1 -> AsyncFile.newInstance((io.vertx.core.file.AsyncFile)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystem that = (FileSystem)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public FileSystem(io.vertx.core.file.FileSystem delegate) {
        this.delegate = delegate;
    }

    public FileSystem(Object delegate) {
        this.delegate = (io.vertx.core.file.FileSystem)delegate;
    }

    public io.vertx.core.file.FileSystem getDelegate() {
        return this.delegate;
    }

    public Future<Void> copy(String from, String to) {
        Future ret = this.delegate.copy(from, to).map(val -> val);
        return ret;
    }

    public Completable rxCopy(String from, String to) {
        return AsyncResultCompletable.toCompletable($handler -> this.copy(from, to).onComplete($handler));
    }

    public Future<Void> copy(String from, String to, CopyOptions options) {
        Future ret = this.delegate.copy(from, to, options).map(val -> val);
        return ret;
    }

    public Completable rxCopy(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable($handler -> this.copy(from, to, options).onComplete($handler));
    }

    public FileSystem copyBlocking(String from, String to) {
        this.delegate.copyBlocking(from, to);
        return this;
    }

    public Future<Void> copyRecursive(String from, String to, boolean recursive) {
        Future ret = this.delegate.copyRecursive(from, to, recursive).map(val -> val);
        return ret;
    }

    public Completable rxCopyRecursive(String from, String to, boolean recursive) {
        return AsyncResultCompletable.toCompletable($handler -> this.copyRecursive(from, to, recursive).onComplete($handler));
    }

    public FileSystem copyRecursiveBlocking(String from, String to, boolean recursive) {
        this.delegate.copyRecursiveBlocking(from, to, recursive);
        return this;
    }

    public Future<Void> move(String from, String to) {
        Future ret = this.delegate.move(from, to).map(val -> val);
        return ret;
    }

    public Completable rxMove(String from, String to) {
        return AsyncResultCompletable.toCompletable($handler -> this.move(from, to).onComplete($handler));
    }

    public Future<Void> move(String from, String to, CopyOptions options) {
        Future ret = this.delegate.move(from, to, options).map(val -> val);
        return ret;
    }

    public Completable rxMove(String from, String to, CopyOptions options) {
        return AsyncResultCompletable.toCompletable($handler -> this.move(from, to, options).onComplete($handler));
    }

    public FileSystem moveBlocking(String from, String to) {
        this.delegate.moveBlocking(from, to);
        return this;
    }

    public Future<Void> truncate(String path, long len) {
        Future ret = this.delegate.truncate(path, len).map(val -> val);
        return ret;
    }

    public Completable rxTruncate(String path, long len) {
        return AsyncResultCompletable.toCompletable($handler -> this.truncate(path, len).onComplete($handler));
    }

    public FileSystem truncateBlocking(String path, long len) {
        this.delegate.truncateBlocking(path, len);
        return this;
    }

    public Future<Void> chmod(String path, String perms) {
        Future ret = this.delegate.chmod(path, perms).map(val -> val);
        return ret;
    }

    public Completable rxChmod(String path, String perms) {
        return AsyncResultCompletable.toCompletable($handler -> this.chmod(path, perms).onComplete($handler));
    }

    public FileSystem chmodBlocking(String path, String perms) {
        this.delegate.chmodBlocking(path, perms);
        return this;
    }

    public Future<Void> chmodRecursive(String path, String perms, String dirPerms) {
        Future ret = this.delegate.chmodRecursive(path, perms, dirPerms).map(val -> val);
        return ret;
    }

    public Completable rxChmodRecursive(String path, String perms, String dirPerms) {
        return AsyncResultCompletable.toCompletable($handler -> this.chmodRecursive(path, perms, dirPerms).onComplete($handler));
    }

    public FileSystem chmodRecursiveBlocking(String path, String perms, String dirPerms) {
        this.delegate.chmodRecursiveBlocking(path, perms, dirPerms);
        return this;
    }

    public Future<Void> chown(String path, String user, String group) {
        Future ret = this.delegate.chown(path, user, group).map(val -> val);
        return ret;
    }

    public Completable rxChown(String path, String user, String group) {
        return AsyncResultCompletable.toCompletable($handler -> this.chown(path, user, group).onComplete($handler));
    }

    public FileSystem chownBlocking(String path, String user, String group) {
        this.delegate.chownBlocking(path, user, group);
        return this;
    }

    public Future<FileProps> props(String path) {
        Future ret = this.delegate.props(path).map(val -> val);
        return ret;
    }

    public Single<FileProps> rxProps(String path) {
        return AsyncResultSingle.toSingle($handler -> this.props(path).onComplete($handler));
    }

    public FileProps propsBlocking(String path) {
        FileProps ret = this.delegate.propsBlocking(path);
        return ret;
    }

    public Future<FileProps> lprops(String path) {
        Future ret = this.delegate.lprops(path).map(val -> val);
        return ret;
    }

    public Single<FileProps> rxLprops(String path) {
        return AsyncResultSingle.toSingle($handler -> this.lprops(path).onComplete($handler));
    }

    public FileProps lpropsBlocking(String path) {
        FileProps ret = this.delegate.lpropsBlocking(path);
        return ret;
    }

    public Future<Void> link(String link, String existing) {
        Future ret = this.delegate.link(link, existing).map(val -> val);
        return ret;
    }

    public Completable rxLink(String link, String existing) {
        return AsyncResultCompletable.toCompletable($handler -> this.link(link, existing).onComplete($handler));
    }

    public FileSystem linkBlocking(String link, String existing) {
        this.delegate.linkBlocking(link, existing);
        return this;
    }

    public Future<Void> symlink(String link, String existing) {
        Future ret = this.delegate.symlink(link, existing).map(val -> val);
        return ret;
    }

    public Completable rxSymlink(String link, String existing) {
        return AsyncResultCompletable.toCompletable($handler -> this.symlink(link, existing).onComplete($handler));
    }

    public FileSystem symlinkBlocking(String link, String existing) {
        this.delegate.symlinkBlocking(link, existing);
        return this;
    }

    public Future<Void> unlink(String link) {
        Future ret = this.delegate.unlink(link).map(val -> val);
        return ret;
    }

    public Completable rxUnlink(String link) {
        return AsyncResultCompletable.toCompletable($handler -> this.unlink(link).onComplete($handler));
    }

    public FileSystem unlinkBlocking(String link) {
        this.delegate.unlinkBlocking(link);
        return this;
    }

    public Future<String> readSymlink(String link) {
        Future ret = this.delegate.readSymlink(link).map(val -> val);
        return ret;
    }

    public Single<String> rxReadSymlink(String link) {
        return AsyncResultSingle.toSingle($handler -> this.readSymlink(link).onComplete($handler));
    }

    public String readSymlinkBlocking(String link) {
        String ret = this.delegate.readSymlinkBlocking(link);
        return ret;
    }

    public Future<Void> delete(String path) {
        Future ret = this.delegate.delete(path).map(val -> val);
        return ret;
    }

    public Completable rxDelete(String path) {
        return AsyncResultCompletable.toCompletable($handler -> this.delete(path).onComplete($handler));
    }

    public FileSystem deleteBlocking(String path) {
        this.delegate.deleteBlocking(path);
        return this;
    }

    public Future<Void> deleteRecursive(String path, boolean recursive) {
        Future ret = this.delegate.deleteRecursive(path, recursive).map(val -> val);
        return ret;
    }

    public Completable rxDeleteRecursive(String path, boolean recursive) {
        return AsyncResultCompletable.toCompletable($handler -> this.deleteRecursive(path, recursive).onComplete($handler));
    }

    public FileSystem deleteRecursiveBlocking(String path, boolean recursive) {
        this.delegate.deleteRecursiveBlocking(path, recursive);
        return this;
    }

    public Future<Void> mkdir(String path) {
        Future ret = this.delegate.mkdir(path).map(val -> val);
        return ret;
    }

    public Completable rxMkdir(String path) {
        return AsyncResultCompletable.toCompletable($handler -> this.mkdir(path).onComplete($handler));
    }

    public FileSystem mkdirBlocking(String path) {
        this.delegate.mkdirBlocking(path);
        return this;
    }

    public Future<Void> mkdir(String path, String perms) {
        Future ret = this.delegate.mkdir(path, perms).map(val -> val);
        return ret;
    }

    public Completable rxMkdir(String path, String perms) {
        return AsyncResultCompletable.toCompletable($handler -> this.mkdir(path, perms).onComplete($handler));
    }

    public FileSystem mkdirBlocking(String path, String perms) {
        this.delegate.mkdirBlocking(path, perms);
        return this;
    }

    public Future<Void> mkdirs(String path) {
        Future ret = this.delegate.mkdirs(path).map(val -> val);
        return ret;
    }

    public Completable rxMkdirs(String path) {
        return AsyncResultCompletable.toCompletable($handler -> this.mkdirs(path).onComplete($handler));
    }

    public FileSystem mkdirsBlocking(String path) {
        this.delegate.mkdirsBlocking(path);
        return this;
    }

    public Future<Void> mkdirs(String path, String perms) {
        Future ret = this.delegate.mkdirs(path, perms).map(val -> val);
        return ret;
    }

    public Completable rxMkdirs(String path, String perms) {
        return AsyncResultCompletable.toCompletable($handler -> this.mkdirs(path, perms).onComplete($handler));
    }

    public FileSystem mkdirsBlocking(String path, String perms) {
        this.delegate.mkdirsBlocking(path, perms);
        return this;
    }

    public Future<List<String>> readDir(String path) {
        Future ret = this.delegate.readDir(path).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxReadDir(String path) {
        return AsyncResultSingle.toSingle($handler -> this.readDir(path).onComplete($handler));
    }

    public List<String> readDirBlocking(String path) {
        List ret = this.delegate.readDirBlocking(path);
        return ret;
    }

    public Future<List<String>> readDir(String path, String filter) {
        Future ret = this.delegate.readDir(path, filter).map(val -> val);
        return ret;
    }

    public Single<List<String>> rxReadDir(String path, String filter) {
        return AsyncResultSingle.toSingle($handler -> this.readDir(path, filter).onComplete($handler));
    }

    public List<String> readDirBlocking(String path, String filter) {
        List ret = this.delegate.readDirBlocking(path, filter);
        return ret;
    }

    public Future<Buffer> readFile(String path) {
        Future ret = this.delegate.readFile(path).map(val -> val);
        return ret;
    }

    public Single<Buffer> rxReadFile(String path) {
        return AsyncResultSingle.toSingle($handler -> this.readFile(path).onComplete($handler));
    }

    public Buffer readFileBlocking(String path) {
        Buffer ret = this.delegate.readFileBlocking(path);
        return ret;
    }

    public Future<Void> writeFile(String path, Buffer data) {
        Future ret = this.delegate.writeFile(path, data).map(val -> val);
        return ret;
    }

    public Completable rxWriteFile(String path, Buffer data) {
        return AsyncResultCompletable.toCompletable($handler -> this.writeFile(path, data).onComplete($handler));
    }

    public FileSystem writeFileBlocking(String path, Buffer data) {
        this.delegate.writeFileBlocking(path, data);
        return this;
    }

    public Future<AsyncFile> open(String path, OpenOptions options) {
        Future ret = this.delegate.open(path, options).map(val -> AsyncFile.newInstance(val));
        return ret;
    }

    public Single<AsyncFile> rxOpen(String path, OpenOptions options) {
        return AsyncResultSingle.toSingle($handler -> this.open(path, options).onComplete($handler));
    }

    public AsyncFile openBlocking(String path, OpenOptions options) {
        AsyncFile ret = AsyncFile.newInstance(this.delegate.openBlocking(path, options));
        return ret;
    }

    public Future<Void> createFile(String path) {
        Future ret = this.delegate.createFile(path).map(val -> val);
        return ret;
    }

    public Completable rxCreateFile(String path) {
        return AsyncResultCompletable.toCompletable($handler -> this.createFile(path).onComplete($handler));
    }

    public FileSystem createFileBlocking(String path) {
        this.delegate.createFileBlocking(path);
        return this;
    }

    public Future<Void> createFile(String path, String perms) {
        Future ret = this.delegate.createFile(path, perms).map(val -> val);
        return ret;
    }

    public Completable rxCreateFile(String path, String perms) {
        return AsyncResultCompletable.toCompletable($handler -> this.createFile(path, perms).onComplete($handler));
    }

    public FileSystem createFileBlocking(String path, String perms) {
        this.delegate.createFileBlocking(path, perms);
        return this;
    }

    public Future<Boolean> exists(String path) {
        Future ret = this.delegate.exists(path).map(val -> val);
        return ret;
    }

    public Single<Boolean> rxExists(String path) {
        return AsyncResultSingle.toSingle($handler -> this.exists(path).onComplete($handler));
    }

    public boolean existsBlocking(String path) {
        boolean ret = this.delegate.existsBlocking(path);
        return ret;
    }

    public Future<FileSystemProps> fsProps(String path) {
        Future ret = this.delegate.fsProps(path).map(val -> val);
        return ret;
    }

    public Single<FileSystemProps> rxFsProps(String path) {
        return AsyncResultSingle.toSingle($handler -> this.fsProps(path).onComplete($handler));
    }

    public FileSystemProps fsPropsBlocking(String path) {
        FileSystemProps ret = this.delegate.fsPropsBlocking(path);
        return ret;
    }

    public Future<String> createTempDirectory(String prefix) {
        Future ret = this.delegate.createTempDirectory(prefix).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix) {
        return AsyncResultSingle.toSingle($handler -> this.createTempDirectory(prefix).onComplete($handler));
    }

    public String createTempDirectoryBlocking(String prefix) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix);
        return ret;
    }

    public Future<String> createTempDirectory(String prefix, String perms) {
        Future ret = this.delegate.createTempDirectory(prefix, perms).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String prefix, String perms) {
        return AsyncResultSingle.toSingle($handler -> this.createTempDirectory(prefix, perms).onComplete($handler));
    }

    public String createTempDirectoryBlocking(String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(prefix, perms);
        return ret;
    }

    public Future<String> createTempDirectory(String dir, String prefix, String perms) {
        Future ret = this.delegate.createTempDirectory(dir, prefix, perms).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempDirectory(String dir, String prefix, String perms) {
        return AsyncResultSingle.toSingle($handler -> this.createTempDirectory(dir, prefix, perms).onComplete($handler));
    }

    public String createTempDirectoryBlocking(String dir, String prefix, String perms) {
        String ret = this.delegate.createTempDirectoryBlocking(dir, prefix, perms);
        return ret;
    }

    public Future<String> createTempFile(String prefix, String suffix) {
        Future ret = this.delegate.createTempFile(prefix, suffix).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix) {
        return AsyncResultSingle.toSingle($handler -> this.createTempFile(prefix, suffix).onComplete($handler));
    }

    public String createTempFileBlocking(String prefix, String suffix) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix);
        return ret;
    }

    public Future<String> createTempFile(String prefix, String suffix, String perms) {
        Future ret = this.delegate.createTempFile(prefix, suffix, perms).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempFile(String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle($handler -> this.createTempFile(prefix, suffix, perms).onComplete($handler));
    }

    public String createTempFileBlocking(String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(prefix, suffix, perms);
        return ret;
    }

    public Future<String> createTempFile(String dir, String prefix, String suffix, String perms) {
        Future ret = this.delegate.createTempFile(dir, prefix, suffix, perms).map(val -> val);
        return ret;
    }

    public Single<String> rxCreateTempFile(String dir, String prefix, String suffix, String perms) {
        return AsyncResultSingle.toSingle($handler -> this.createTempFile(dir, prefix, suffix, perms).onComplete($handler));
    }

    public String createTempFileBlocking(String dir, String prefix, String suffix, String perms) {
        String ret = this.delegate.createTempFileBlocking(dir, prefix, suffix, perms);
        return ret;
    }

    public static FileSystem newInstance(io.vertx.core.file.FileSystem arg) {
        return arg != null ? new FileSystem(arg) : null;
    }
}

