/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.core;

import io.reactivex.Maybe;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.ThreadingModel;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxDelegate;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.impl.AsyncResultMaybe;
import java.util.List;
import java.util.concurrent.Callable;

@RxGen(value=io.vertx.core.Context.class)
public class Context
implements RxDelegate {
    public static final TypeArg<Context> __TYPE_ARG = new TypeArg(obj -> new Context((io.vertx.core.Context)obj), Context::getDelegate);
    private final io.vertx.core.Context delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context that = (Context)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public Context(io.vertx.core.Context delegate) {
        this.delegate = delegate;
    }

    public Context(Object delegate) {
        this.delegate = (io.vertx.core.Context)delegate;
    }

    public io.vertx.core.Context getDelegate() {
        return this.delegate;
    }

    public static boolean isOnWorkerThread() {
        boolean ret = io.vertx.core.Context.isOnWorkerThread();
        return ret;
    }

    public static boolean isOnEventLoopThread() {
        boolean ret = io.vertx.core.Context.isOnEventLoopThread();
        return ret;
    }

    public static boolean isOnVertxThread() {
        boolean ret = io.vertx.core.Context.isOnVertxThread();
        return ret;
    }

    public void runOnContext(Handler<Void> action) {
        this.delegate.runOnContext(action);
    }

    public String deploymentID() {
        String ret = this.delegate.deploymentID();
        return ret;
    }

    public JsonObject config() {
        JsonObject ret = this.delegate.config();
        return ret;
    }

    @Deprecated
    public List<String> processArgs() {
        List ret = this.delegate.processArgs();
        return ret;
    }

    public boolean isEventLoopContext() {
        boolean ret = this.delegate.isEventLoopContext();
        return ret;
    }

    public boolean isWorkerContext() {
        boolean ret = this.delegate.isWorkerContext();
        return ret;
    }

    public ThreadingModel threadingModel() {
        ThreadingModel ret = this.delegate.threadingModel();
        return ret;
    }

    public <T> T get(Object key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public void put(Object key, Object value) {
        this.delegate.put(key, value);
    }

    public boolean remove(Object key) {
        boolean ret = this.delegate.remove(key);
        return ret;
    }

    public Vertx owner() {
        Vertx ret = Vertx.newInstance(this.delegate.owner());
        return ret;
    }

    public int getInstanceCount() {
        int ret = this.delegate.getInstanceCount();
        return ret;
    }

    public Context exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        Future ret = this.delegate.executeBlocking(blockingCodeHandler, ordered).map(val -> val);
        return ret;
    }

    public <T> Maybe<T> rxExecuteBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler, ordered).onComplete($handler));
    }

    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler) {
        Future ret = this.delegate.executeBlocking(blockingCodeHandler).map(val -> val);
        return ret;
    }

    public <T> Maybe<T> rxExecuteBlocking(Callable<T> blockingCodeHandler) {
        return AsyncResultMaybe.toMaybe($handler -> this.executeBlocking(blockingCodeHandler).onComplete($handler));
    }

    public static Context newInstance(io.vertx.core.Context arg) {
        return arg != null ? new Context(arg) : null;
    }
}

